# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Standard Manupilation modules that are not directly UI based.
"""
from PyQt4.QtCore import pyqtSignature
from PIL import Image
from filters.toolbox import *
from core import *
import math
import os.path

@pyqtSignature("")
def FileOpenReleased(self):
    """
    Key Press to launch File open dialog, store image and display on GUI
    """
    ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
    if ImgTemp != "":
        self.core.current.imageageLoc = ImgTemp
    self.FileImageOpen(self.core.curImageLoc)
    
        
@pyqtSignature("String")
def FileImageOpen(self,  filename):
    """
    Open File and poulate class parameters of Image.
    """
    try:
        self.ToggleThumbWait(True)
        self.repaint()
        del self.core.undoList_IM[:]
        self.core.current.image = (Image.open(filename))
        self.core.curImageLoc = filename
        FileImageRefresh(self)
        
    except:
        return


@pyqtSignature("")
def FileImageRefresh(self):
    FileImageLoadSizes(self)
    self.core.UndoImage_Push()
    FileImageDisplayRefresh(self)
        
        
@pyqtSignature("Image")
def FileImageLoadSizes(self):
    try:
        w, h = self.core.current.image.size
        wTh,  hTh = convertImSize(self.core, w, h,  250)

        size = (wTh,  hTh )
        self.core.current.thumb = self.core.current.image.resize(size, Image.ANTIALIAS)
        self.core.current.setThumbDisplaySize(155-int(wTh/2),  195-int(hTh/2), wTh, hTh)

        wTh,  hTh = convertImSize(self.core,  w, h,  796)
        self.core.current.setImageDisplaySize(398-int(wTh/2), 216-int(hTh/2), wTh, hTh)
        self.core.EXIFLoaded = False
        #Store Undo Image

    except:
        print "Error"

@pyqtSignature("Bool")
def FileImageDisplayRefresh(self):
    """
    Display image on GUI
    """
    try:
        self.ToggleThumbWait(True)
        
        self.photo.setGeometry(QRect(0, 0, 0, 0))
        self.photo_Thumb.setGeometry(QRect(0, 0, 0, 0))
        
        self.photo_Thumb.setPixmap(pil2qpixmap(self.core.current.thumb))
        self.photo.setPixmap(pil2qpixmap(self.core.current.image))
        
        self.photo.setGeometry(self.core.current.getImageDisplaySize())
        self.photo_Thumb.setGeometry(self.core.current.getThumbDisplaySize())
        self.btnFullScreen.setGeometry(self.core.current.getThumbDisplaySize())
        
        self.ToggleThumbWait(False)
    except:
        return
        

def StripFilename(self,  myPath):
    (dirName, fileName) = os.path.split(myPath)
    (fileBaseName, fileExtension)=os.path.splitext(fileName)
    return (dirName, fileBaseName, fileExtension)

def MostRecentImage(self):
    files =[]
    for file in os.listdir(self.core.imageDir):
        files.append(file)
