# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow GUI, anselA
"""
import os
import sys
import glob
import ui.EXIF
import math
import operator
import webbrowser
import ui.AnselA_Filters as Filters
import ui.AnselA_Core as Core
import ui.AnselA_Graphics as Graphics
from PIL import Image
from PIL import ImageDraw
from PIL import ImageEnhance

from PyQt4 import *
from PyQt4 import QtGui
from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature
from ui.Ui_mainWindow import Ui_MainWindow


#from flickcharm import *


class MainWindow(QMainWindow, Ui_MainWindow,  Core.ParamValues):
    """
    Main Window Class for AnselA
    """
    val=Core.ParamValues()
        
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.movie = QtGui.QMovie()
        self.ImageOpen(self.val.curImageLoc)
        self.postSetup()
        self.ImageDisplayRefresh(True)
        self.ShowApply(False)


    def postSetup(self):
        self.tabStrip.setCurrentIndex(0)

    @pyqtSignature("Bool")
    def ShowApply(self, Show):
        if self.val.ApplyVisible <> Show:
            self.val.ApplyVisible = Show
            if Show:
                self.btnLevelApply.setVisible(True)
                self.btnLevelReset.setVisible(True)
            else:
                self.btnLevelApply.setVisible(False)
                self.btnLevelReset.setVisible(False)
        
    @pyqtSignature("Bool, Image")
    def showUpdateLabel(self, show,  thumb):
        self.ShowApply(True)
        self.lockUpdating = show
        if (thumb == True):
            if (show == True):
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 251, 161))
            else:
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 0, 161))
        else:
            if (show == True):
                self.FullScreenToggle(True)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 797, 433))
            else:
                self.FullScreenToggle(False)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 0, 433))
        self.labWait.repaint()
        self.repaint()

    
    @pyqtSignature("")
    def on_btn_Grey_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "L"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Red_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "R"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Green_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "G"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Blue_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "B"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
 
    @pyqtSignature("")
    def on_btn_Yellow_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "Y"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Cyan_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "C"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Magenta_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "M"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)


    @pyqtSignature("")
    def on_btnLevelApply_released(self):
        """
        Slot documentation goes here.
        """
        if (self.val.valCurTab == 5):
            self.RotateApply(self.val.valRot)
        elif (self.val.valCurTab == 1):
            self.BWApply(self.val.curIm, self.val.valBW,  True)
        else:
            self.LevelApply(self.val.curIm,  True)
        
        self.ShowApply(False)
        self.ReturnHistPlots()
    
    @pyqtSignature("Image,String,Bool")
    def BWApply(self, imageToEdit,  cSource,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2
            imCMYK=im.convert("CMYK")
            C, M, Y, K = imCMYK.split()
            N =  Image.new('L', im.size, (0))
            
            
            if cSource == "R":
#                out0=source[R].point(lambda i: i * 3)
#                source[R].paste(out0,  None,  None)
#                out1=source[G].point(lambda i: i * 0)
#                source[G].paste(out1,  None,  None)
#                out2=source[B].point(lambda i: i * 0)
#                source[B].paste(out2,  None,  None)
#                im=Image.merge("RGB", (out0 ,  source[G],  source[B] ))
                im = source[R].convert("L")
            elif cSource == "G":
#                out=source[R].point(lambda i: i * 1)
#                source[R].paste(out,  None,  None)
#                out=source[G].point(lambda i: i * 1.9)
#                source[G].paste(out,  None,  None)
#                out=source[B].point(lambda i: i * 1)
#                source[B].paste(out,  None,  None)
#                im=Image.merge("RGB", (source[R] ,  source[G],  source[B] ))
#                im=im.convert("L")
                im = source[G].convert("L")
            elif cSource == "B":
                #source[B].point(lambda i: i * 1.2)
                im = source[B].convert("L")
            elif cSource == "C":
#                source[B].point(lambda i: i * 1.2)
#                source[G].point(lambda i: i * 1.2)
                out = Image.merge("RGB", (N, source[G],  source[B]))
                im = out.convert("L")
            elif cSource == "BC":
                out = Image.merge("RGB", (source[B], source[G],  source[B]))
                im = out.convert("L")
            elif cSource == "BM":
                out = Image.merge("RGB", (source[R], source[B],  source[B]))
                im = out.convert("L")
            elif cSource == "M":
#                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .5)
#                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .5)
                out = Image.merge("RGB", (source[R], N,  source[B])  )
                im = out.convert("L")
            elif cSource == "RM":
#                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .33)
#                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .66)
                out = Image.merge("RGB", (source[R], source[R],  source[B]) )
                im = out.convert("L")
            elif cSource == "RY":
                out = Image.merge("RGB", (source[R], source[G],  source[R]) )
                im = out.convert("L")
            elif cSource == "Y":
#                source[R].point(lambda i: i * 1.66)
#                source[G].point(lambda i: i * 1.66)
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")
            elif cSource == "GY":
                out = Image.merge("RGB", (source[R], source[G],  source[G]) )
                im = out.convert("L")                
            elif cSource == "GC":
                out = Image.merge("RGB", (source[G], source[G],  source[B]) )
                im = out.convert("L")    
            
            im = im.convert("RGB")

            
            if (UpdateRealImage == True):
                self.photo.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("")
    def LevelApply(self, imageToEdit,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2

            out = source[R].point(lambda i: i *Core.valToScalar(self.val.valR))
            source[R].paste(out, None, None)

            out = source[G].point(lambda i: i *Core.valToScalar(self.val.valG))
            source[G].paste(out, None, None)

            out = source[B].point(lambda i: i *Core.valToScalar(self.val.valB))
            source[B].paste(out, None, None)
            
            im = Image.merge(im.mode, source)
            
            if (UpdateRealImage == True):
                self.photo.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("int")
    def on_cSlide_B_valueChanged(self, value):
        """ 
        Slot documentation goes here.
        """
        self.val.valB = value
        self.lcdB.setText(str(self.val.valB))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valR = value
        self.lcdR.setText(str(self.val.valR))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valG = value
        self.lcdG.setText(str(self.val.valG))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("")
    def on_btnLevelReset_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_R.setValue(0)
        self.cSlide_G.setValue(0)
        self.cSlide_B.setValue(0)
        self.LevelApply(self.val.curThumb,  False)
        self.LevelApply(self.val.curIm,  True)
    
    @pyqtSignature("")
    def on_minMax_released(self):
        """
        Slot documentation goes here.
        """
        MinMax()

    def on_photo_released(self):
        """
        Slot documentation goes here.
        """
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    @pyqtSignature("int")
    def on_tabStrip_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index==9):
            self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            self.ReturnHistPlots()
        elif (index==7):
            self.PopulateEXIFData(self.val.curImageLoc)
        else:
            self.val.valCurTab = index
        

    @pyqtSignature("")
    def on_btnLevelReset2_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_Sat.setValue(0)
        self.cSlide_Contrast.setValue(0)
        self.cSlide_Bright.setValue(0)
        
    @pyqtSignature("")
    def TonesApply(self):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            self.showUpdateLabel(True)
            im = self.val.curIm
            imL = im.convert("")
            enhancer = ImageEnhance.Brightness(im)
            bright_im = enhancer.enhance(self.val.valL*-1*0.01) #any value you want
            self.photo.setPixmap(Core.pil2qpixmap(bright_im))
            self.showUpdateLabel(False)
    
    
    @pyqtSignature("")
    def BrightContrastSatSharpApply(self, imageToEdit,  cSource,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
                
            if cSource =="Br": 
                enhancer = ImageEnhance.Brightness(im)
                Eim = enhancer.enhance(self.val.valBr*-1*0.001)
            if cSource =="Co":
                enhancer = ImageEnhance.Contrast(im)
                Eim = enhancer.enhance(self.val.valCo*-1*0.001) 
            if cSource =="Sa":
                enhancer = ImageEnhance.Color(im)
                Eim = enhancer.enhance(self.val.valSa*-1*0.001) 
            if cSource =="Sh":    
                enhancer = ImageEnhance.Sharpness(im)
                Eim = enhancer.enhance(self.val.valSh*-1*0.001) 
            
            if (UpdateRealImage == True):
                self.val.curIm = Eim
                self.photo.setPixmap(Core.pil2qpixmap(self.val.curIm))
                self.showUpdateLabel(False,  False)
            else:
                self.val.curThumb = Eim
                self.photo_Thumb.setPixmap(Core.pil2qpixmap(self.val.curThumb))
                self.showUpdateLabel(False,  True)

    
    @pyqtSignature("")
    def on_btnOpen_released(self):
        """
        Key Press to launch File open dialog, store image and display on GUI
        """
        ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
        if ImgTemp != "":
            self.val.curImageLoc = ImgTemp
        self.ImageOpen(self.val.curImageLoc)
        self.ImageDisplayRefresh(True)
        
    def ImageOpen(self, filename):
        """
        Open File and poulate class parameters of Image.
        """
        self.ToggleThumbWait(True)
        self.repaint()
        self.val.curIm= (Image.open(filename))
      
        self.val.origIm = self.val.curIm.copy()
        self.ImageLoad(self.val.curIm, True)
        self.val.EXIFLoaded = False
    
    
    @pyqtSignature("Bool")
    def ImageDisplayRefresh(self,  LoadOriginal):
        """
        Display image on GUI
        """
        self.ImageLoad(self.val.curIm,  False)
        self.photo_Thumb.setPixmap(Core.pil2qpixmap(self.val.curThumb))
        if LoadOriginal:
            self.photo_Orig.setPixmap(Core.pil2qpixmap(self.val.curIm))
        self.photo.setPixmap(Core.pil2qpixmap(self.val.curIm))
        self.btnFullScreen.setGeometry(self.photo_Thumb.geometry())
    
    
    def PopulateEXIFData(self,  filename):
        if not self.val.EXIFLoaded:
            self.val.EXIFLoaded = True
            self.listEXIFData.clear()
            p = open(filename, "rb")
            tags = ui.EXIF.process_file(p)
            
            for key in tags.keys():
                try:
                    newItem = str("%s: %s" %(key, tags[key]))
                    
                    if key == "Image Orientation":
                        if newItem == "Image Orientation: Horizontal (normal)":
                            self.val.valOrient = 0
                        else:
                            self.val.valOrient = 1
                        
                    if (newItem !="" and  newItem.startswith("Maker Note") == False  and  newItem.startswith("MakerNote") == False  and  newItem.startswith("EXIF") == False):
                        self.listEXIFData.addItem(newItem)
                        #self.listView
                except Exception, e:
                    continue
                
    def convertImSize(self, origW,  origH,  dConstraint):
        if (self.val.valOrient == 0): #landscape
            scale=origW/(dConstraint*1.0001)
            newW=dConstraint
            newH=int(math.ceil(origH/scale))
        else: # portrait
            scale=origH/(dConstraint*1.0001)
            newH=dConstraint
            newW=int(math.ceil(origW/scale))
            
        return newW,  newH
    
    @pyqtSignature("Image, Bool")
    def ImageLoad(self, im,  LoadOriginal):
        
        self.val.curIm = im
        w, h = self.val.curIm.size
        wTh,  hTh = self.convertImSize(w, h,  250)
        
        size = (wTh,  hTh )
        self.val.curThumb = im.resize(size, Image.ANTIALIAS)
        
        self.labWaitThumb.setGeometry(QtCore.QRect(155-int(wTh/2), 195-int(hTh/2), wTh, hTh))
        self.photo_Thumb.setGeometry(QtCore.QRect(155-int(wTh/2), 195-int(hTh/2), wTh, hTh))


        
        if LoadOriginal:
            wTh,  hTh = self.convertImSize(w, h,  796)
            self.photo_Orig.setGeometry(QtCore.QRect(398-int(wTh/2), 216-int(hTh/2), wTh, hTh))
            #self.photo_Orig.repaint()
            
        wTh,  hTh = self.convertImSize(w, h,  796)
        self.photo.setGeometry(QtCore.QRect(398-int(wTh/2), 216-int(hTh/2), wTh, hTh))
        
        self.ToggleThumbWait(False)
        #self.photo.repaint()

        #800, 440
        #self.curThumb.thumbnail(size, Image.ANTIALIAS)
        # resize makes a copy thumbnail modifies
        #self.ImageDisplayOrig()


    @pyqtSignature("int")
    def on_tabPhoto_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index == 2):
            self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 0, 0, 0))
            if self.val.thumbsCount == 0:
                self.populatePhotoList()
        else:
            self.btnFullScreenClose.setGeometry(QtCore.QRect(0, 90, 800, 371))

#+++++++++++++++++++++++ END of Class    

    @pyqtSignature("int")
    def on_cSlide_Hi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valHi = value
        self.lcdHi.setText(str(self.val.valHi))
    
    @pyqtSignature("int")
    def on_cSlide_Mi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valMi = value
        self.lcdMi.setText(str(self.val.valMi))
    
    @pyqtSignature("int")
    def on_cSlide_Sw_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSw = value
        self.lcdSw.setText(str(self.val.valSw))
        
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSh = value
        self.lcdSh.setText(str(self.val.valSh))
        self.BrightContrastSatSharpApply(self.val.curThumb,  "Sh",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSa = value
        self.lcdSa.setText(str(self.val.valSa))
        self.BrightContrastSatSharpApply(self.val.curThumb,  "Sa",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valCo = value
        self.lcdCo.setText(str(self.val.valCo))
        self.BrightContrastSatSharpApply(self.val.curThumb,  "Co",  False)
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valBr = value
        self.lcdBr.setText(str(self.val.valBr))
        self.BrightContrastSatSharpApply(self.val.curThumb,  "Br",  False)
        
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            self.val.valRot = value
            self.lcdRot_1.setText(str(self.val.valRot))
            self.RotateThumb(value)
           
    
    @pyqtSignature("int")
    def RotateThumb(self, rotation):
        self.showUpdateLabel(True,  True)
        im=self.val.curThumb
        
        im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
        draw = ImageDraw.Draw(im)
        draw.rectangle(self.RotateCalc(rotation, im))
        
        del draw
        self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
        self.showUpdateLabel(False,  True)
        
    
    @pyqtSignature("int")    
    def RotateApply(self, rotation):
        if  (self.val.lockUpdating == False):
            self.showUpdateLabel(True,  False)
            im=self.val.curIm
            im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
            w1, h1, w2, h2 = self.RotateCalc(rotation, im)
            
            self.val.curIm = im.crop((w1, h1, w2, h2))
            self.ImageDisplayRefresh(False)
            self.showUpdateLabel(False,  False)
            self.val.lockUpdating = False
    
    @pyqtSignature("int, Image")
    def RotateCalc(self, rotation,  im):

        w, h = im.size
        theta =math.radians(rotation)

        botOps = round(abs(h * math.sin(theta))/2)
        botAdj = round(abs(h * math.cos(theta))/2)

        topOps = round(abs(w * math.sin(theta))/2)
        topAdj = round(abs(w * math.cos(theta))/2)
        
        theta = theta + math.pi/4
        if theta >= 6.28:
            theta = theta - 6.28
        pi2 = math.pi/2
        
        if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
            return([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
        elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
            return([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 


    @pyqtSignature("")
    def on_btnExitCancel_released(self):
        self.tabStrip.setCurrentIndex(self.val.valCurTab)
        self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    @pyqtSignature("")
    def on_btnExitGo_released(self):
        sys.exit()
    
    @pyqtSignature("")
    def on_btn_rot_none_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Vert_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90cw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90ccw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Horz_pressed(self):
        """
        Slot documentation goes here.
        """
        
#     out = im.transpose(Image.FLIP_LEFT_RIGHT)
#     out = im.transpose(Image.FLIP_TOP_BOTTOM)
#     out = im.transpose(Image.ROTATE_90)
#     out = im.transpose(Image.ROTATE_180)
#     out = im.transpose(Image.ROTATE_270)
#     out
#    
#    
    @pyqtSignature("")
    def on_btn_rot_180_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btnFullScreen_released(self):
        """
        utton handler for fullscreen  open, calls FullScreenToggle
        """
        self.FullScreenToggle(True)
    
    @pyqtSignature("")
    def on_btnFullScreenClose_released(self):
        """
        Button handler for fullscreen  close, calls FullScreenToggle
        """
        self.FullScreenToggle(False)

    @pyqtSignature("")
    def FullScreenToggle(self,  Show,  ForceTab=0):
        """
        Slot documentation goes here.
        """
        if (Show):
            self.tabPhoto.setCurrentIndex(ForceTab)
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 800, 480))    
            self.photo.repaint()
            self.photo_Orig.repaint()
        else:
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 0, 0))
            
        self.tabPhoto.updateGeometry()
        self.tabStrip.repaint()
        self.repaint()
    
    @pyqtSignature("")
    def on_btn_BC_released(self):
        """
        Black and white conversion to Blue-Cyan
        """
        self.val.valBW = "BC"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GC_released(self):
        """
        Black and white conversion to Green-Cyan
        """
        self.val.valBW = "GC"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GY_released(self):
        """
        Black and white conversion to Green-Yellow
        """
        self.val.valBW = "GY"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_BM_released(self):
        """
        Black and white conversion to Blue-Magenta
        """
        self.val.valBW = "BM"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
        
    @pyqtSignature("")
    def on_btn_RM_released(self):
        """
        Black and white conversion to Red-Magenta
        """
        self.val.valBW = "RM"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_RY_released(self):
        """
        Black and white conversion to Red-yellow
        """
        self.val.valBW = "RY"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)

    @pyqtSignature("")
    def ReturnHistPlots(self):
        """
        Slot documentation goes here.
        """
        histo=self.val.curIm.histogram()
        OrignX=37
        OrignY=108

        ScaleMax=(max(histo)/100)  #256)
        print ScaleMax

        plotList =list()
        valX=0

        for valY in histo:
            ProcVal =int(valY/ScaleMax)
            plotList.append(ProcVal)
    
        plotR = Image.new("RGB", self.val.plotIm.size)
        plotG = Image.new("RGB", self.val.plotIm.size)
        plotB = Image.new("RGB", self.val.plotIm.size)
        
        plotR.paste(self.val.plotIm)# = self.val.poltIm.copy()
        plotG.paste(self.val.plotIm)
        plotB.paste(self.val.plotIm)
        
        drawR = ImageDraw.Draw(plotR)
        drawG = ImageDraw.Draw(plotG)
        drawB = ImageDraw.Draw(plotB)        

        valX=0
        sortCol = list()
        for x in range(255):
            plotX =OrignX + x
            drawR.line([plotX, OrignY, plotX, OrignY-plotList[x]], fill="red")
            drawG.line([plotX, OrignY, plotX, OrignY-plotList[x+256]], fill="green")
            drawB.line([plotX, OrignY, plotX, OrignY-plotList[x+512]], fill="blue")
        del drawR
        del drawG
        del drawB

        #return plotIm
        
        self.graphRed.setPixmap(Core.pil2qpixmap(plotR.convert("RGB")))
        self.graphGreen.setPixmap(Core.pil2qpixmap(plotG.convert("RGB")))
        self.graphBlue.setPixmap(Core.pil2qpixmap(plotB.convert("RGB")))
    
    
    @pyqtSignature("")
    def on_btnBug_released(self):
        """
        Submit bug report to bugs.maemo.org
        """ 
        webbrowser.open("https://bugs.maemo.org/enter_bug.cgi?product=AnselA")

    @pyqtSignature("")
    def on_btnPListCancel_released(self):
        """
        Slot documentation goes here.
        """
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.val.populatePhotoList = False
    
    def LoadCurImageFromPhotoBrowser(self):
        self.ToggleThumbWait(True)
        self.FullScreenToggle(False)
        self.repaint()
        self.ImageOpen(self.val.plistIm)
        self.ImageDisplayRefresh(True)
        
    @pyqtSignature("")
    def on_btnPlistZoom_released(self):
        """
        This button displays the Zoomed Image, click on it will edit the photo.
        """
        self.LoadCurImageFromPhotoBrowser()
        #self.listPhotos.setCurrentRow(8)

    def ToggleThumbWait(self,  Show):
        if Show:
            self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 251, 161))

        else:
            self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 0, 0))
    
    @pyqtSignature("")
    def on_butReturn_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(False)
    
    
    @pyqtSignature("QListWidgetItem*")
    def on_listPhotos_itemDoubleClicked(self, item):
        """
        Slot documentation goes here.
        """
        self.LoadCurImageFromPhotoBrowser()
    
    @pyqtSignature("")
    def on_btnReloadPList_released(self):
        """
        Slot documentation goes here.
        """
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 791, 441))
    
    @pyqtSignature("")
    def on_btnReloadCancel_released(self):
        """
        Slot documentation goes here.
        """
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
    
    @pyqtSignature("")
    def on_btnReloadGo_released(self):
        """
        Slot documentation goes here.
        """
        self.btnEditZoomed.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.frameReloadRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        self.populatePhotoList(True)
    
    @pyqtSignature("")
    def on_btnPhotoBrowser_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(True,  2)
        
        if self.val.thumbsCount == 0:
             self.populatePhotoList()
    
    @pyqtSignature("")
    def on_dial_sliderReleased(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("QListWidgetItem*")
    def on_listPhotos_itemPressed(self, item):
        """
        Slot documentation goes here.
        """
        self.setZoomPhoto(item)
        #self.photoListZoom.setPixmap(item.icon().pixmap(item.getIconSize()[0],item.getIconSize()[1]))

    @pyqtSignature("Bool")
    def populatePhotoList(self, ForceRefresh=False):
        """
        Slot documentation goes here.
        """

        if self.val.thumbsCount == 0:
            self.val.thumbsCount =51
            
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 800, 441))
        self.val.populatePhotoList = True
        self.listPhotos.clear()
        
        self.repaint()
        self.tabPhoto.repaint()
        Tsize = (100,  100)
        i=0
        self.labCancel.setText("Loading Photos...")
        self.labCancel.repaint()
        if not os.path.exists (self.val.thumbsDir):
            os.makedirs (self.val.thumbsDir)
        
        files =[]
        for file in os.listdir(self.val.imageDir):
            files.append(file)
            
        for file in reversed(files):
            if self.val.populatePhotoList ==True:

                if ((not os.path.exists(self.val.thumbsDir+file)) or ForceRefresh):
                    try:
                        im = Image.open(self.val.imageDir+file)
                        im.thumbnail((Tsize), Image.NEAREST)
                        #os.remove(self.val.thumbsDir+file)
                        im.save(self.val.thumbsDir+file)
                    except:
                        continue
                
                try:
                    photoItem = PlistWidgetItem()
                    im=Image.open(self.val.thumbsDir+file,  "r" )
                    icon =QtGui.QIcon(self.val.thumbsDir+file)
                    photoItem.setIcon(icon)
                    photoItem.setText(file.replace(".jpg", ""))
                    photoItem.setIconSize(im.size[0], im.size[1])
                    photoItem.setImageLocation(self.val.thumbsDir+file)
                    photoItem.setImageLocation(self.val.curImageLoc+file)
                    h, w = self.convertImSize(im.size[0], im.size[1],  400)
                    photoItem.setIconZoomSize(self.ScaleLabel(220,  380, w,  h))
                    self.listPhotos.addItem(photoItem)
                    self.listPhotos.item(i).setIcon(icon)
                    if i % 5 == 0:
                        self.labCancel.setText("Loading Photos..."+str(i))
                        self.labCancel.repaint()
                except:
                        continue
                        
                i+=1
                if i == self.val.thumbsCount:
                    self.listPhotos.addItem("Load More...")
                    break
                    
        self.listPhotos.repaint()
        self.frameCancelPListLoad.setGeometry(QtCore.QRect(0, 0, 0, 0))


    @pyqtSignature("QListWidgetItem*")
    def on_listPhotos_itemClicked(self, item):
        """
        Slot documentation goes here.
        """
        if str(item.text()) == "Load More...":
            self.val.thumbsCount +=100
            self.populatePhotoList()
            self.btnEditZoomed.setGeometry(QtCore.QRect(220, 280, 281, 0))
        else:
            #self.photoListZoom.setPixmap(item.icon().pixmap(item.getIconZoomSize().height(),  item.getIconZoomSize().width()))
            self.photoListZoom.setGeometry(item.getIconZoomSize())
            self.btnPlistZoom.setGeometry(self.photoListZoom.geometry())
            self.val.plistIm= self.val.imageDir+str(item.text())+".jpg"
            im = Image.open(self.val.plistIm)
            wTh,  hTh = self.convertImSize(im.size[0], im.size[1],  400)
            
            plistTim=im.resize((hTh,  wTh))
            self.photoListZoom.setPixmap(Core.pil2qpixmap(plistTim))
            self.photoListZoom.repaint()
            #self.photoListZoom.setGeometry(self.ScaleLabel(220,  340, hTh,  wTh))
            
    @pyqtSignature("QListWidgetItem*")
    def setZoomPhoto(self, item):
        """
        Slot documentation goes here.
        """
#        w, h=item.getIconSize()
#        self.photoListZoom.setGeometry(self.ScaleLabel(220,  340, h, w ))
#        self.photoListZoom.setPixmap(item.icon().pixmap(h,  w))

    @pyqtSignature("int, int, int, int")
    def ScaleLabel(self, yH, xW, h, w):
        """
        Send widget x(Width), y(Height) of center point
        and h,w of image passed.
        """
        return QtCore.QRect(xW-int(w/2), yH-int(h/2), w, h)


class PlistWidgetItem(QtGui.QListWidgetItem):
    iconSize =(0, 0)
    iconZoomSize =(0, 0, 0, 0)
    thumbLocation= ""
    imageLocation =""
    
    def setIconSize(self,  Height=0,  Width=0):
        self.iconSize =(Height,  Width)

    def getIconSize(self):
        return self.iconSize

    def setIconZoomSize(self, value):
        self.iconZoomSize = value
        
    def getIconZoomSize(self):
        return self.iconZoomSize
        
    def getImageLocation(self):
        return self.imageLocation

    def setImageLocation(self, value):
        self.imageLocation = value

    def getThumbLocation(self):
        return self.thumbLocation

    def setThumbLocation(self, value):
        self.thumbLocation = value
    
    
    
    
    
    
