# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow GUI, anselA
"""

import os
import sys
import EXIF
import math
import operator
import webbrowser
import AnselA_Filters as Filters
import AnselA_Core as Core
import AnselA_Graphics as Graphics
from PIL import Image
from PIL import ImageDraw
from PIL import ImageEnhance
from PyQt4 import QtGui
from PyQt4 import QtCore 
from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature
from Ui_mainWindow import Ui_MainWindow


class MainWindow(QMainWindow, Ui_MainWindow,  Core.ParamValues):
    """
    Main Window Class for AnselA
    """
    val=Core.ParamValues()
        
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.ImageOpen(self.val.curImageLoc)
        self.postSetup()
        self.ImageDisplayRefresh(True)
        self.ShowApply(False)
    
    def postSetup(self):
        self.tabStrip.setCurrentIndex(0)

    @pyqtSignature("Bool")
    def ShowApply(self, Show):
        if self.val.ApplyVisible <> Show:
            self.val.ApplyVisible = Show
            if Show:
                self.btnLevelApply.setVisible(True)
                self.btnLevelReset.setVisible(True)
            else:
                self.btnLevelApply.setVisible(False)
                self.btnLevelReset.setVisible(False)
        
    @pyqtSignature("Bool, Image")
    def showUpdateLabel(self, show,  thumb):
        self.ShowApply(True)
        self.lockUpdating = show
        if (thumb == True):
            if (show == True):
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 251, 161))
            else:
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 0, 161))
        else:
            if (show == True):
                self.FullScreenToggle(True)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 800, 441))
            else:
                self.FullScreenToggle(False)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 0, 441))
        self.labWait.repaint()
        self.repaint()

    
    @pyqtSignature("")
    def on_btn_Grey_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "L"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Red_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "R"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Green_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "G"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Blue_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "B"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
 
    @pyqtSignature("")
    def on_btn_Yellow_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "Y"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Cyan_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "C"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_Magenta_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "M"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)


    @pyqtSignature("")
    def on_btnLevelApply_released(self):
        """
        Slot documentation goes here.
        """
        if (self.val.valCurTab == 5):
            self.RotateApply(self.val.valRot)
        elif (self.val.valCurTab == 1):
            self.BWApply(self.val.curIm, self.val.valBW,  True)
        else:
            self.LevelApply(self.val.curIm,  True)           
        
        self.ShowApply(False)
    
    @pyqtSignature("Image,String,Bool")
    def BWApply(self, imageToEdit,  cSource,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2
            imCMYK=im.convert("CMYK")
            C, M, Y, K = imCMYK.split()
            N =  Image.new('L', im.size, (0))
            
            
            if cSource == "R":
                out0=source[R].point(lambda i: i * 3)
                source[R].paste(out0,  None,  None)
                out1=source[G].point(lambda i: i * 0)
                source[G].paste(out1,  None,  None)
                out2=source[B].point(lambda i: i * 0)
                source[B].paste(out2,  None,  None)
                im=Image.merge("RGB", (out0 ,  source[G],  source[B] ))
                im=im.convert("L")
            elif cSource == "G":
                out=source[R].point(lambda i: i * 1)
                source[R].paste(out,  None,  None)
                out=source[G].point(lambda i: i * 1.9)
                source[G].paste(out,  None,  None)
                out=source[B].point(lambda i: i * 1)
                source[B].paste(out,  None,  None)
                im=Image.merge("RGB", (source[R] ,  source[G],  source[B] ))
                im=im.convert("L")
            elif cSource == "B":
                #source[B].point(lambda i: i * 1.2)
                im = source[R].convert("L")
            elif cSource == "C":
                source[B].point(lambda i: i * 1.2)
                source[G].point(lambda i: i * 1.2)
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")
            elif cSource == "BC":
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")
            elif cSource == "BM":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .33)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .66)
                out = Image.merge("RGB", (source[R], N,  source[B]) )
                im = out.convert("L")
            elif cSource == "M":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .5)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .5)
                out = Image.merge("RGB", (source[R], N,  source[B])  )
                im = out.convert("L")
            elif cSource == "RM":
                source[R].point(lambda i: i +source[G].getpixel((0,0)) * .33)
                source[B].point(lambda i: i +source[G].getpixel((0,0)) * .66)
                out = Image.merge("RGB", (source[R], N,  source[B])  )
                im = out.convert("L")
            elif cSource == "RY":
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")
            elif cSource == "Y":
                source[R].point(lambda i: i * 1.66)
                source[G].point(lambda i: i * 1.66)
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")
            elif cSource == "GY":
                out = Image.merge("RGB", (source[R], source[G],  N) )
                im = out.convert("L")                
            elif cSource == "GC":
                out = Image.merge("RGB", (N, source[G],  source[B]) )
                im = out.convert("L")    
            
            im = im.convert("RGB")

            
            if (UpdateRealImage == True):
                self.photo.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("")
    def LevelApply(self, imageToEdit,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2

            out = source[R].point(lambda i: i *Core.valToScalar(self.val.valR))
            source[R].paste(out, None, None)

            out = source[G].point(lambda i: i *Core.valToScalar(self.val.valG))
            source[G].paste(out, None, None)

            out = source[B].point(lambda i: i *Core.valToScalar(self.val.valB))
            source[B].paste(out, None, None)
            
            im = Image.merge(im.mode, source)
            
            if (UpdateRealImage == True):
                self.photo.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("int")
    def on_cSlide_B_valueChanged(self, value):
        """ 
        Slot documentation goes here.
        """
        self.val.valB = value
        self.lcdB.setText(str(self.val.valB))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valR = value
        self.lcdR.setText(str(self.val.valR))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valG = value
        self.lcdG.setText(str(self.val.valG))
        self.LevelApply(self.val.curThumb,  False)
    
    @pyqtSignature("")
    def on_btnLevelReset_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_R.setValue(0)
        self.cSlide_G.setValue(0)
        self.cSlide_B.setValue(0)
        self.LevelApply(self.val.curThumb,  False)
        self.LevelApply(self.val.curIm,  True)
    
    @pyqtSignature("")
    def on_minMax_released(self):
        """
        Slot documentation goes here.
        """
        MinMax()

    def on_photo_released(self):
        """
        Slot documentation goes here.
        """
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    @pyqtSignature("int")
    def on_tabStrip_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index==9):
            self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 800, 480))
        elif  (index==6):
            self.ReturnHistPlots()
        elif (index==8):
            self.AnimateTab()
        else:
            self.val.valCurTab = index
        

    @pyqtSignature("")
    def on_btnLevelReset2_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_Sat.setValue(0)
        self.cSlide_Contrast.setValue(0)
        self.cSlide_Bright.setValue(0)
    
    @pyqtSignature("")
    def on_btnLevelApply2_released(self):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            self.showUpdateLabel(True)
            im = self.val.curIm
            enhancer = ImageEnhance.Brightness(im)
            bright_im = enhancer.enhance(self.val.valL*-1*0.01) #any value you want
            self.photo.setPixmap(Core.pil2qpixmap(bright_im))
            self.showUpdateLabel(False)
    
    @pyqtSignature("")
    def on_btnOpen_released(self):
        """
        Key Press to launch File open dialog, store image and display on GUI
        """
        ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
        if ImgTemp != "":
            self.val.curImageLoc = ImgTemp
        self.ImageOpen(self.val.curImageLoc)
        self.ImageDisplayRefresh(True)
        
    @pyqtSignature("Bool")
    def ImageDisplayRefresh(self,  LoadOriginal) :
        """
        Display image on GUI
        """
        self.ImageLoad(self.val.curIm,  False)
        self.photo.setPixmap(Core.pil2qpixmap(self.val.curIm))
        if LoadOriginal:
            self.photo_Orig.setPixmap(Core.pil2qpixmap(self.val.curIm))
        self.photo_Thumb.setPixmap(Core.pil2qpixmap(self.val.curThumb))
        self.btnFullScreen.setGeometry(self.photo_Thumb.geometry())
    
    def ImageOpen(self, filename):
        """
        Open File and poulate class parameters of Image.
        """
        self.val.curIm = Image.open(filename)
        
        p = open(filename, "rb")
        tags = EXIF.process_file(p)
        for key in tags.keys():
            try:
                newItem = str("%s: %s" %(key, tags[key]))
                
                if key == "Image Orientation":
                    if newItem == "Image Orientation: Horizontal (normal)":
                        self.val.valOrient = 0
                    else:
                        self.val.valOrient = 1
                    
                if (newItem !="" and  newItem.startswith("Maker Note") == False  and  newItem.startswith("MakerNote") == False  and  newItem.startswith("EXIF") == False):
                    self.listEXIFData.addItem(newItem)
                    self.listView
            except Exception, e:
                continue
                #print "EXIF Error"
      
        self.val.origIm = self.val.curIm.copy()
        self.ImageLoad(self.val.curIm, True)
      
    def convertImSize(self, origW,  origH,  dConstraint):
        if (self.val.valOrient == 0): #landscape
            scale=origW/dConstraint
            newW=dConstraint
            newH=int(math.ceil(origH/scale))
        else: # portrait
            scale=origH/dConstraint
            newH=dConstraint
            newW=int(math.ceil(origW/scale))
            
        return newW,  newH
    
    @pyqtSignature("Image, Bool")
    def ImageLoad(self, im,  LoadOriginal):
        
        self.val.curIm = im
        w, h = self.val.curIm.size
        wTh,  hTh = self.convertImSize(w, h,  250)
        self.photo_Thumb.setGeometry(QtCore.QRect(155-int(wTh/2), 195-int(hTh/2), wTh, hTh))

        size = (wTh,  hTh )
        self.val.curThumb = im.resize(size, Image.ANTIALIAS)
        self.photo_Thumb.repaint()
        
        if LoadOriginal:
            wTh,  hTh = self.convertImSize(w, h,  800)
            self.photo_Orig.setGeometry(QtCore.QRect(400-int(wTh/2), 220-int(hTh/2), wTh, hTh))
            self.photo_Orig.repaint()
            
        wTh,  hTh = self.convertImSize(w, h,  800)
        self.photo.setGeometry(QtCore.QRect(400-int(wTh/2), 220-int(hTh/2), wTh, hTh))
        self.photo.repaint()

        #800, 440
        #self.curThumb.thumbnail(size, Image.ANTIALIAS)
        # resize makes a copy thumbnail modifies
        #self.ImageDisplayOrig()


    @pyqtSignature("int")
    def on_tabPhoto_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
#        if (index == 0):
#            self.FullScreenToggle(False)
#        else:
#            self.FullScreenToggle(True)

#+++++++++++++++++++++++ END of Class    
    

    @pyqtSignature("int")
    def on_cSlide_Hi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valHi = value
        self.lcdHi.setText(str(self.val.valHi))
    
    @pyqtSignature("int")
    def on_cSlide_Mi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valMi = value
        self.lcdMi.setText(str(self.val.valMi))
    
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSh = value
        self.lcdSh.setText(str(self.val.valSh))
    
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSa = value
        self.lcdSa.setText(str(self.val.valSa))
        
    @pyqtSignature("int")
    def on_cSlide_Sw_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valSw = value
        self.lcdSw.setText(str(self.val.valSw))
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valCo = value
        self.lcdCo.setText(str(self.val.valCo))
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.val.valBr = value
        self.lcdBr.setText(str(self.val.valBr))
    
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        if  (self.val.lockUpdating == False):
            self.val.valRot = value
            self.lcdRot_1.setText(str(self.val.valRot))
            self.RotateThumb(value)
           

    def RotateThumb(self, rotation):
        self.showUpdateLabel(True,  True)
        im=self.val.curThumb
        
        im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
        draw = ImageDraw.Draw(im)
        draw.rectangle(self.RotateCalc(rotation, im))
        
        del draw
        self.photo_Thumb.setPixmap(Core.pil2qpixmap(im))
        self.showUpdateLabel(False,  True)
        
    def RotateApply(self, rotation):
        if  (self.val.lockUpdating == False):
            self.showUpdateLabel(True,  False)
            im=self.val.curIm
            im = im.rotate(rotation,  resample=Image.BICUBIC,  expand=0)
            w1, h1, w2, h2 = self.RotateCalc(rotation, im)
            
            self.val.curIm = im.crop((w1, h1, w2, h2))
            self.ImageDisplayRefresh(False)
            self.showUpdateLabel(False,  False)
            self.val.lockUpdating = False
        
    def RotateCalc(self, rotation,  im):

        w,  h = im.size
        theta =math.radians(rotation)

        botOps = round(abs(h * math.sin(theta))/2)
        botAdj = round(abs(h * math.cos(theta))/2)

        topOps = round(abs(w * math.sin(theta))/2)
        topAdj = round(abs(w * math.cos(theta))/2)
        
        theta = theta + math.pi/4
        if theta >= 6.28:
            theta = theta - 6.28
        pi2 = math.pi/2
        
        if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
            return([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
        elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
            return([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
        elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
            return([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 


    @pyqtSignature("")
    def on_btnExitCancel_released(self):
        self.tabStrip.setCurrentIndex(self.val.valCurTab)
        self.frameExitRequest.setGeometry(QtCore.QRect(0, 0, 0, 0))
        
    @pyqtSignature("")
    def on_btnExitGo_released(self):
        sys.exit()
    
    @pyqtSignature("")
    def on_btn_rot_none_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Vert_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90cw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_90ccw_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_rot_Horz_pressed(self):
        """
        Slot documentation goes here.
        """
        
        #out = im.transpose(Image.FLIP_LEFT_RIGHT)
        #out = im.transpose(Image.FLIP_TOP_BOTTOM)
        #out = im.transpose(Image.ROTATE_90)
        #out = im.transpose(Image.ROTATE_180)
        #out = im.transpose(Image.ROTATE_270)

    
    @pyqtSignature("")
    def on_btn_rot_180_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btnFullScreen_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(True)
    
    @pyqtSignature("")
    def on_btnFullScreenClose_released(self):
        """
        Slot documentation goes here.
        """
        self.FullScreenToggle(False)

    @pyqtSignature("")
    def FullScreenToggle(self,  Show):
        """
        Slot documentation goes here.
        """
        if (Show):
            self.tabPhoto.setCurrentIndex(0)
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 800, 480))    
            #self.tabStrip.setGeometry(QtCore.QRect(190, 120, 691, 491))
        else:
            self.framePhoto.setGeometry(QtCore.QRect(0, 0, 0, 0))
            #self.tabStrip.setGeometry(QtCore.QRect(190, 40, 691, 491))
            self.photo.repaint()
            self.photo_Orig.repaint()
            
        self.tabPhoto.repaint()
        self.tabStrip.repaint()
        self.repaint()
    
    @pyqtSignature("")
    def on_btn_BC_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "BC"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GC_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "GC"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_GY_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "GY"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_BM_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "BM"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
        
    @pyqtSignature("")
    def on_btn_RM_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "RM"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)
    
    @pyqtSignature("")
    def on_btn_RY_released(self):
        """
        Slot documentation goes here.
        """
        self.val.valBW = "RY"
        self.BWApply(self.val.curThumb,  self.val.valBW,  False)

    @pyqtSignature("")
    def ReturnHistPlots(self):
        """
        Slot documentation goes here.
        """
        histo=self.val.curIm.histogram()
        OrignX=37
        OrignY=108

        ScaleMax=(max(histo)/100)  #256)
        print ScaleMax

        plotList =list()
        valX=0

        for valY in histo:
            ProcVal =int(valY/ScaleMax)
            plotList.append(ProcVal)
    
        plotR = Image.new("RGB", self.val.plotIm.size)
        plotG = Image.new("RGB", self.val.plotIm.size)
        plotB = Image.new("RGB", self.val.plotIm.size)
        
        plotR.paste(self.val.plotIm)# = self.val.poltIm.copy()
        plotG.paste(self.val.plotIm)
        plotB.paste(self.val.plotIm)
        
        drawR = ImageDraw.Draw(plotR)
        drawG = ImageDraw.Draw(plotG)
        drawB = ImageDraw.Draw(plotB)        

        valX=0
        sortCol = list()
        for x in range(255):
            plotX =OrignX + x
            drawR.line([plotX, OrignY, plotX, OrignY-plotList[x]], fill="red")
            drawG.line([plotX, OrignY, plotX, OrignY-plotList[x+256]], fill="green")
            drawB.line([plotX, OrignY, plotX, OrignY-plotList[x+512]], fill="blue")
        del drawR
        del drawG
        del drawB

        #return plotIm
        
        self.graphRed.setPixmap(Core.pil2qpixmap(plotR.convert("RGB")))
        self.graphGreen.setPixmap(Core.pil2qpixmap(plotG.convert("RGB")))
        self.graphBlue.setPixmap(Core.pil2qpixmap(plotB.convert("RGB")))
    
    
    @pyqtSignature("")
    def on_btnBug_released(self):
        """
        Slot documentation goes here.
        """
 
        webbrowser.open("https://bugs.maemo.org/enter_bug.cgi?product=AnselA")
        
        
    

        
