# -*- coding: utf-8 -*-
#CPE 1704 TKS
"""
Module implementing MainWindow.
"""
import math
import sys
from PIL import Image, ImageEnhance, ImageDraw

from PyQt4 import QtGui
from PyQt4 import QtCore 
from PyQt4.QtGui import QMainWindow
from PyQt4.QtCore import pyqtSignature
from Ui_mainWindow import Ui_MainWindow


def Enhance(self, im, name, lo, hi):
# set up the image
    im=curIm
    self.enhancer = enhancer(im)
    self.update("1.0") # normalize

    self.value = eval(value)
    
def MinMax():
    if (self.isFullScreen):
        self.showFullScreen()
    else:
        self.showNormal()

def pil2qpixmap(pil_image):
    w, h = pil_image.size
    data = pil_image.tostring("raw", "BGRX")
    qimage = QtGui.QImage(data, w, h, QtGui.QImage.Format_RGB32)
    qpixmap = QtGui.QPixmap(w,h)
    pix = QtGui.QPixmap.fromImage(qimage)
    return pix

def valToScalar(value): #, soft):
    """
    Calculates an appropiate value to scale from / to
    """
#    if (soft == True):
#        if (value >0):
#            return 1+(math.exp(2-((99-value)*6/100)))
#        if (value <0):
#            return 1-((math.exp(2-((99+value)*6/100)))/8)
#        if (value ==0):
#            return 1
#    else:
    if (value >0):
        return 1+value/20.0
    if (value <0):
        return 1+(value*0.01)
    if (value ==0):
        return 1

class MainWindow(QMainWindow, Ui_MainWindow):
    """
    Main Window Class for AnselA
    """
    valR = 0
    valB = 0
    valG = 0
    valSa = 0
    valBr = 0
    valCo = 0
    valHi =0
    valMi =0
    valSh =0
    valSa =0
    wMaximized = True
    lockUpdating = False
    curImageLoc ="ui/resources/landscapeRepo.jpg"
    curIm =""
    curThumb = ""
        
    def __init__(self, parent = None):
        """
        Constructor
        """
        QMainWindow.__init__(self, parent)
        self.setupUi(self)
        self.ImageOpen(self.curImageLoc)
    #Comment
    
    def showUpdateLabel(self, show,  thumb):
        self.lockUpdating = show
        if (thumb == True):
            if (show == True):
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 251, 161))
            else:
                self.labWaitThumb.setGeometry(QtCore.QRect(30, 120, 0, 161))
        else:
            if (show == True):
                self.tabPhoto.setCurrentIndex(1)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 800, 441))
            else:
                self.tabPhoto.setCurrentIndex(0)
                self.labWait.setGeometry(QtCore.QRect(0, 0, 0, 441))
        self.labWait.repaint()
        self.repaint()

    
    @pyqtSignature("")
    def on_btn_Grey_released(self):
        """
        Slot documentation goes here.
        """
        pil_img = Image.open(self.curImageLoc)
        self.photo.setPixmap(pil2qpixmap(pil_img))
    
    @pyqtSignature("")
    def on_btn_Red_released(self):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            self.showUpdateLabel(True)
            im = self.curIm #Image.open(self.curImageLoc)
            source = im.split()
            R, G, B = 0, 1, 2

            out = source[R].point(lambda i: i *valToScalar(self.valR))
            source[R].paste(out, None, None)
            
            im = Image.merge(im.mode, source)
            self.curIm = im
            self.photo.setPixmap(pil2qpixmap(self.curIm))
        
            self.showUpdateLabel(False)
    
    @pyqtSignature("")
    def on_btn_Green_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
    
    @pyqtSignature("")
    def on_btn_Blue_released(self):
        """
        Slot documentation goes here.
        """
        # TODO: not implemented yet
        raise NotImplementedError
 
    @pyqtSignature("")
    def on_btnLevelApply_released(self):
        """
        Slot documentation goes here.
        """
        self.LevelApply(self.curIm,  True)
           
           
    @pyqtSignature("")
    def LevelApply(self, imageToEdit,  UpdateRealImage):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            if (UpdateRealImage == True):
                self.showUpdateLabel(True,  False)
            else:
                self.showUpdateLabel(True,  True)
                
            im = imageToEdit
            source = im.split()
            R, G, B = 0, 1, 2

            out = source[R].point(lambda i: i *valToScalar(self.valR))
            source[R].paste(out, None, None)

            out = source[G].point(lambda i: i *valToScalar(self.valG))
            source[G].paste(out, None, None)

            out = source[B].point(lambda i: i *valToScalar(self.valB))
            source[B].paste(out, None, None)
            
            im = Image.merge(im.mode, source)
            
            if (UpdateRealImage == True):
                self.photo.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  False)
            else:
                self.photo_Thumb.setPixmap(pil2qpixmap(im))
                self.showUpdateLabel(False,  True)
    
    @pyqtSignature("int")
    def on_cSlide_B_valueChanged(self, value):
        """ 
        Slot documentation goes here.
        """
        self.valB = value
        self.lcdB.setText(str(self.valB))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_R_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valR = value
        self.lcdR.setText(str(self.valR))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("int")
    def on_cSlide_G_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valG = value
        self.lcdG.setText(str(self.valG))
        self.LevelApply(self.curThumb,  False)
    
    @pyqtSignature("")
    def on_btnLevelReset_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_R.setValue(0)
        self.cSlide_G.setValue(0)
        self.cSlide_B.setValue(0)
        self.LevelApply(self.curThumb,  False)
        self.LevelApply(self.curIm,  True)
    
    @pyqtSignature("")
    def on_minMax_released(self):
        """
        Slot documentation goes here.
        """
        MinMax()

    def on_photo_released(self):
        """
        Slot documentation goes here.
        """
        QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")

    @pyqtSignature("int")
    def on_tabStrip_currentChanged(self, index):
        """
        Slot documentation goes here.
        """

    @pyqtSignature("")
    def on_btnLevelReset2_released(self):
        """
        Slot documentation goes here.
        """
        self.cSlide_Sat.setValue(0)
        self.cSlide_Contrast.setValue(0)
        self.cSlide_Bright.setValue(0)
    
    @pyqtSignature("")
    def on_btnLevelApply2_released(self):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            self.showUpdateLabel(True)
            im = self.curIm
            enhancer = ImageEnhance.Brightness(im)
            bright_im = enhancer.enhance(self.valL*-1*0.01) #any value you want
            self.photo.setPixmap(pil2qpixmap(bright_im))
            self.showUpdateLabel(False)
    
    @pyqtSignature("")
    def on_btnOpen_released(self):
        """
        Key Press to launch File open dialog, store image and display on GUI
        """
        ImgTemp= str(QtGui.QFileDialog.getOpenFileName(self, 'Open File', '/home/user/MyDocs/DCIM/', ("Images (*.png *.jpg)")))
        if ImgTemp != "":
            self.curImageLoc = ImgTemp
        self.ImageOpen(self.curImageLoc)
        ImageDisplayOrig()
        
    def ImageDisplayOrig(self):
        """
        Display image on GUI
        """
        self.photo.setPixmap(pil2qpixmap(self.curIm))
        self.photo_Orig.setPixmap(pil2qpixmap(self.curIm))
        self.photo_Thumb.setPixmap(pil2qpixmap(self.curThumb))
    
    def ImageOpen(self, filename):
        """
        Open File and poulate class parameters of Image.
        """
        self.curIm = Image.open(filename)
        
        size = 150, 90
        self.curThumb = Image.open(filename)
        self.curThumb.thumbnail(size)
        #self.curThumb = im
        
        self.ImageDisplayOrig()


    @pyqtSignature("int")
    def on_tabPhoto_currentChanged(self, index):
        """
        Slot documentation goes here.
        """
        if (index == 0):
            self.tabPhoto.setGeometry(QtCore.QRect(0, 40, 321, 491))
            self.tabStrip.setGeometry(QtCore.QRect(320, 40, 561, 481))
            self.photo.repaint()
            self.photo_Orig.repaint()
        else:
            self.tabPhoto.setGeometry(QtCore.QRect(0, 40, 800, 491))
            self.tabStrip.setGeometry(QtCore.QRect(320, 80, 561, 481))
            
        self.tabPhoto.repaint()
        self.tabStrip.repaint()
        self.repaint()
#+++++++++++++++++++++++ END of Class    
    

    @pyqtSignature("")
    def on_btnExit_released(self):
        """
        Slot documentation goes here.
        """
        sys.exit()
    
    @pyqtSignature("int")
    def on_cSlide_Hi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valHi = value
        self.lcdHi.setText(str(self.valHi))
    
    @pyqtSignature("int")
    def on_cSlide_Mi_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valMi = value
        self.lcdMi.setText(str(self.valMi))
    
    @pyqtSignature("int")
    def on_cSlide_Sh_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSh = value
        self.lcdSh.setText(str(self.valSh))
    
    @pyqtSignature("int")
    def on_cSlide_Sa_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSa = value
        self.lcdSa.setText(str(self.valSa))
        
    @pyqtSignature("int")
    def on_cSlide_Sw_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valSw = value
        self.lcdSw.setText(str(self.valSw))
    
    @pyqtSignature("int")
    def on_cSlide_Co_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valCo = value
        self.lcdCo.setText(str(self.valCo))
    
    @pyqtSignature("int")
    def on_cSlide_Br_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        self.valBr = value
        self.lcdBr.setText(str(self.valBr))
    
    @pyqtSignature("int")
    def on_dial_valueChanged(self, value):
        """
        Slot documentation goes here.
        """
        if  (self.lockUpdating == False):
            self.showUpdateLabel(True,  True)
            
            im = self.curThumb
            im = im.rotate(value, resample=Image.BICUBIC,  expand=0)
            w,  h = im.size
            draw = ImageDraw.Draw(im)
            theta =math.radians(value)
             
            botOps = round(abs(h * math.sin(theta))/2)
            botAdj = round(abs(h * math.cos(theta))/2)

            topOps = round(abs(w * math.sin(theta))/2)
            topAdj = round(abs(w * math.cos(theta))/2)
            
            theta = theta + math.pi/4
            if theta >= 6.28:
                theta = theta - 6.28
            pi2 = math.pi/2
            
            if( theta >= 0.0 and theta < pi2 ): #0 - 1.57 
                draw.rectangle([botOps,botOps, int(w-botOps),  int(h-botOps)]) 
                self.lcdRot_1.setText("1")
            elif( theta >= pi2 and theta < math.pi): # 1.57 - 3.14
                draw.rectangle([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
                self.lcdRot_1.setText("2")
            elif( theta >= math.pi and theta < (math.pi + pi2) ): # 3.14 - 4.71
                draw.rectangle([botOps, botOps, int(w-botOps),  int(h-botOps)]) 
                self.lcdRot_1.setText("3")
            elif( theta >= (math.pi + pi2)):  # 4.71 - 6.28 ok 
                draw.rectangle([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
                self.lcdRot_1.setText("4")
            
            self.lcdRot_2.setText(str(round(theta, 2)))
            self.lcdRot_bo.setText(str(botOps))
            self.lcdRot_ba.setText(str(botAdj))
            self.lcdRot_ta.setText(str(topAdj))
            self.lcdRot_to.setText(str(topOps))
            
            del draw 
            self.photo_Thumb.setPixmap(pil2qpixmap(im))
            self.showUpdateLabel(False,  True)



#            w, h = im.size
#            draw = ImageDraw.Draw(im)
#            theta =math.radians(rotation)
#
#            cos = math.cos(theta)
#            sin = math.sin(theta)
#            W = w
#            H = h
#            h0 = (H*cos-W*sin)/(cos*cos-sin*sin)
#            w0 = (W-h0*sin)/cos
#
#            X = 0
#            Y = 0
#            x1 = abs(h0*sin)
#            y1 = abs(w0*sin)
#            x2 = abs(h0*sin)
#            y2 = abs(h0*cos)
#
#            #im=im.crop((int(x1), int(y1), int(x2), int(y2)))
#            draw.rectangle([int(x1), int(y1), int(x2), int(y2)])      
#            theta = math.radians(value)
#            #Calc Ops and Adjacent sides of triangle from Height.
#
#
#            h_new = h*abs(math.cos(theta)) + w*abs(math.sin(theta)) 
#            w_new = w*abs(math.cos(theta)) + h*abs(math.sin(theta))
#            self.lcdRot_1.setText(str(round(theta, 2)))
#            self.lcdRot_2.setText(str(round(value, 2)))
#            self.lcdRot_3.setText(str(round(h_new, 2)))
#            self.lcdRot_4.setText(str(round(w_new, 2)))
#
#            h_rec = round((h - (h * (h/h_new)))/2)
#            w_rec = round((w - (w * (w/w_new)))/2)
            

#            botOps = round(abs(h * math.sin(theta))/2)
#            botAdj = round(abs(h * math.cos(theta))/2)
#
#            topOps = round(abs(w * math.sin(theta))/2)
#            topAdj = round(abs(w * math.cos(theta))/2)
            
#            pi2 = math.pi/2
#            if( theta >= 0.0 and theta < pi2 ):
#                draw.rectangle([botOps,topOps, int(w-botOps),  int(h-topOps)]) 
#            elif( theta >= pi2 and theta < math.pi):
#                draw.rectangle([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
#            elif( theta >= math.pi and theta < (math.pi + pi2) ):
#                draw.rectangle([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
#            elif( theta >= (math.pi + pi2)):
#                draw.rectangle([botOps, botAdj, int(w-botOps),  int(h-botAdj)]) 
#                    

#enhancer = ImageEnhance.Sharpness(image)

        #        for i in range(8):
        #            factor = i / 4.0
        #            enhancer.enhance(factor)
        #            


        # multiply each pixel by 1.2
        # out = im.point(lambda i: i * 1.2)
        # split the image into individual bands
        # select regions where red is less than 100
        # QtGui.QMessageBox.information(self, "Loading Data", "Please wait while the data is retrieved...")
        # self.refresh()
        # mask = source[R].point(lambda i: i < 100 and 255)
        # mask = source[G].point(lambda i: i < 100 and 255)
        # out = source[G].point(lambda i: i * 0.01*self.valG)
        # source[G].paste(out, None, mask)
        # mask = source[B].point(lambda i: i < 100 and 255)
        # out = source[B].point(lambda i: i * 0.01*self.valB)
        # source[B].paste(out, None, mask)
        # imout = im.point(lambda i: expression and 255)
    
    
    

        
        
        
        #e2 = "xyz.jpg"
        #im = Image.open(file2)
        #enhancer = ImageEnhance.Brightness(im)
        #bright_im = enhancer.enhance(0.5) #any value you want
        #sharp_im = bright_im.filter(ImageFilter.SHARPEN)
        #sharp_im.save("xyz1.jpg",quality=100)

        #im2 = im.filter(ImageFilter.MinFilter(3))
        #im2 = im.filter(ImageFilter.MinFilter(3))
        #im3 = im.filter(ImageFilter.MinFilter) # same as MinFilter(3)


        #Enhance(self, im, "Contrast", ImageEnhance.Contrast, -1.0, 3.0)
                    

        #Enhance(root, im, "Color", ImageEnhance.Color, 0.0, 4.0).pack()
        #Enhance(Toplevel(), im, "Sharpness", ImageEnhance.Sharpness, -2.0, 2.0).pack()
        #Enhance(Toplevel(), im, "Brightness", ImageEnhance.Brightness, -1.0, 3.0).pack()
        #Enhance(Toplevel(), im, "Contrast", ImageEnhance.Contrast, -1.0, 3.0).pack()
