# -*- coding: utf-8 -*-
# Copyright: Damien Elmes <anki@ichi2.net>
# License: GNU GPL, version 3 or later; http://www.gnu.org/copyleft/gpl.html

import copy, sys
from PyQt4.QtGui import *
from PyQt4.QtCore import *
import anki, anki.utils
from anki.facts import Fact
from anki.stdmodels import JapaneseModel
from ankiqt import ui
import ankiqt.forms

tabs = ("Display",
        "SaveAndSync",
        "Advanced")

class Preferences(QDialog):

    def __init__(self, parent, config):
        QDialog.__init__(self, parent, Qt.Window)
        self.origConfig = config
        self.parent = parent
        self.config = copy.copy(self.origConfig)
        self.origInterfaceLang = self.config['interfaceLang']
        self.dialog = ankiqt.forms.preferences.Ui_Preferences()
        self.dialog.setupUi(self)
        self.supportedLanguages = [
            (_("English"), "en_US"),
            (_("Chinese Traditional"), "zh_TW"),
            (_("Czech"), "cs_CZ"),
            (_("Finnish"), "fi_FI"),
            (_("French"), "fr_FR"),
            (_("German"), "de_DE"),
            (_("Italian"), "it_IT"),
            (_("Japanese"), "ja_JP"),
            (_("Korean"), "ko_KR"),
            (_("Polish"), "pl_PL"),
            (_("Spanish"), "es_ES"),
            ]
        self.connect(self.dialog.buttonBox, SIGNAL("helpRequested()"), self.helpRequested)
        self.setupLang()
        self.setupSync()
        self.setupSave()
        self.setupAdvanced()
        self.show()

    def accept(self):
        self.updateSync()
        self.updateSave()
        self.updateAdvanced()
        self.config['interfaceLang'] = self.origConfig['interfaceLang']
        self.origConfig.update(self.config)
        self.origConfig.save()
        self.parent.setLang()
        self.parent.moveToState("auto")
        self.done(0)

    def reject(self):
        self.accept()

    def setupLang(self):
        # interface lang
        for (lang, code) in self.supportedLanguages:
            self.dialog.interfaceLang.addItem(lang)
        self.connect(self.dialog.interfaceLang,
                     SIGNAL("currentIndexChanged(QString)"),
                     self.interfaceLangChanged)
        self.dialog.interfaceLang.setCurrentIndex(self.codeToIndex(self.config['interfaceLang']))

    def interfaceLangChanged(self):
        self.origConfig['interfaceLang'] = (
            self.supportedLanguages[self.dialog.interfaceLang.currentIndex()])[1]
        self.parent.setLang()
        self.dialog.retranslateUi(self)

    def setupSync(self):
        self.dialog.syncOnOpen.setChecked(self.config['syncOnLoad'])
        self.dialog.syncOnClose.setChecked(self.config['syncOnClose'])
        self.dialog.syncUser.setText(self.config['syncUsername'])
        self.dialog.syncPass.setText(self.config['syncPassword'])

    def updateSync(self):
        self.config['syncOnLoad'] = self.dialog.syncOnOpen.isChecked()
        self.config['syncOnClose'] = self.dialog.syncOnClose.isChecked()
        self.config['syncUsername'] = unicode(self.dialog.syncUser.text())
        self.config['syncPassword'] = unicode(self.dialog.syncPass.text())

    def setupSave(self):
        self.dialog.saveAfterEveryNum.setValue(self.config['saveAfterAnswerNum'])
        self.dialog.saveAfterEvery.setChecked(self.config['saveAfterAnswer'])
        self.dialog.saveAfterAdding.setChecked(self.config['saveAfterAdding'])
        self.dialog.saveAfterAddingNum.setValue(self.config['saveAfterAddingNum'])
        self.dialog.saveWhenClosing.setChecked(self.config['saveOnClose'])

    def updateSave(self):
        self.config['saveAfterAnswer'] = self.dialog.saveAfterEvery.isChecked()
        self.config['saveAfterAnswerNum'] = self.dialog.saveAfterEveryNum.value()
        self.config['saveAfterAdding'] = self.dialog.saveAfterAdding.isChecked()
        self.config['saveAfterAddingNum'] = self.dialog.saveAfterAddingNum.value()
        self.config['saveOnClose'] = self.dialog.saveWhenClosing.isChecked()

    def setupAdvanced(self):
        self.dialog.showEstimates.setChecked(not self.config['suppressEstimates'])
        self.dialog.showStudyOptions.setChecked(self.config['showStudyScreen'])
        self.dialog.showTray.setChecked(self.config['showTrayIcon'])
        self.dialog.showTimer.setChecked(self.config['showTimer'])
        self.dialog.showDivider.setChecked(self.config['qaDivider'])
        self.dialog.splitQA.setChecked(self.config['splitQA'])
        self.dialog.addZeroSpace.setChecked(self.config['addZeroSpace'])
        self.dialog.alternativeTheme.setChecked(self.config['alternativeTheme'])
        if sys.platform.startswith("darwin"):
            self.dialog.alternativeTheme.setChecked(False)
            self.dialog.alternativeTheme.setShown(False)

    def updateAdvanced(self):
        self.config['showTrayIcon'] = self.dialog.showTray.isChecked()
        self.config['showTimer'] = self.dialog.showTimer.isChecked()
        self.config['suppressEstimates'] = not self.dialog.showEstimates.isChecked()
        self.config['showStudyScreen'] = self.dialog.showStudyOptions.isChecked()
        self.config['qaDivider'] = self.dialog.showDivider.isChecked()
        self.config['splitQA'] = self.dialog.splitQA.isChecked()
        self.config['addZeroSpace'] = self.dialog.addZeroSpace.isChecked()
        self.config['alternativeTheme'] = self.dialog.alternativeTheme.isChecked()

    def codeToIndex(self, code):
        n = 0
        for (lang, type) in self.supportedLanguages:
            if code == type:
                return n
            n += 1
        # default to english
        return self.codeToIndex("en_US")

    def helpRequested(self):
        idx = self.dialog.tabWidget.currentIndex()
        QDesktopServices.openUrl(QUrl(ankiqt.appWiki +
                                      "Preferences#" +
                                      tabs[idx]))
