#ifndef APPLICATIONWINDOW_H
#define APPLICATIONWINDOW_H

#include <QMainWindow>
#include <QtGui>

class ImageWidget;

class ApplicationWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ApplicationWindow(QWidget *parent = 0);
    ~ApplicationWindow();

    void addLayoutItems(const QString &);

signals:
    void updateImageWidget(ImageWidget *);

public slots:
    void imageSelected(ImageWidget *);
    void raiseToFront();

private:
    void initUI();

    QScrollArea *scrollArea;
    QLabel      *pageWidget;
    QGridLayout *layout;
};

#endif // APPLICATIONWINDOW_H
