#include "imagewidget.h"
#include <QMouseEvent>
#include <QSound>
#include <QFileInfo>
#include <QtGui>
ImageWidget::ImageWidget(const QPixmap &image, QWidget *parent, Qt::WindowFlags f) :
    QLabel(parent, f)
{
    Q_ASSERT(image);

    setScaledContents(true);
    setPixmap(QPixmap(image));
    if (Qt::Window == f) {
        connect(this, SIGNAL(clicked(ImageWidget *)), SLOT(playSound()));
    }
}

void ImageWidget::mouseReleaseEvent(QMouseEvent *ev)
{
    QPointF diff = ev->posF() - startPoint;
    if (diff.manhattanLength() < 10) {
        emit clicked(this);
    }
}

void ImageWidget::mousePressEvent(QMouseEvent *ev)
{
    startPoint = ev->posF();
}

void ImageWidget::playSound()
{
    QString path = objectName();
    path.replace("jpg", "wav");
    qDebug() << path;
    QStringList args;
    args << path;
    QProcess::startDetached("play-sound", args);
}
