#include "applicationwindow.h"
#include "imagewidget.h"

#include <QtGui>
#include <QDirIterator>

ApplicationWindow::ApplicationWindow(QWidget *parent) :
    QMainWindow(parent)
{

    scrollArea = new QScrollArea;
    scrollArea->setProperty("FingerScrollable", true);
    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    QWidget *scrollWidget = new QWidget;
    layout = new QGridLayout;
    layout->setSizeConstraint(QLayout::SetNoConstraint);
    scrollWidget->setLayout(layout);

    QDirIterator it("/usr/share/applications/AnimalSounds/data");
    while (it.hasNext()) {
        addLayoutItems(it.next());
    }
    scrollArea->setWidget(scrollWidget);
    setCentralWidget(scrollArea);
}

void ApplicationWindow::initUI()
{

}

void ApplicationWindow::addLayoutItems(const QString &imagePath)
{
    static int rows = 0;
    static int cols = 0;

    if (cols > 3) {
        rows++;
        cols = 0;
    }
    QPixmap thumbNail(imagePath);
    if (thumbNail.isNull()) {
        return;
    }
    ImageWidget *image = new ImageWidget(thumbNail);
    image->setMaximumSize(185, 185);
    image->setObjectName(imagePath);
    connect(image, SIGNAL(clicked(ImageWidget *)), this, SLOT(imageSelected(ImageWidget *)));
    layout->addWidget(image, rows, cols++, Qt::AlignCenter);
}

void ApplicationWindow::imageSelected(ImageWidget *image)
{
    ImageWidget *page = new ImageWidget(*(image->pixmap()), this, Qt::Window);
    page->setAttribute(Qt::WA_Maemo5StackedWindow);
    page->setObjectName(image->objectName());
    page->show();
}

void ApplicationWindow::raiseToFront()
{
}

ApplicationWindow::~ApplicationWindow()
{
}
