#include <QtCore/QCoreApplication>

#ifdef Q_WS_MAEMO_5
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#endif

#include "mainwindow.h"
#include "asettings.h"
#include "about.h"

extern qreal g_n;
extern qreal a_max;
extern int divisions;
extern int angle_step;
extern int smoothing;

int data_rate = 0;

#ifdef Q_WS_MAEMO_5
static QDBusConnection dBusConnection = QDBusConnection::systemBus();
#endif

MainWindow::MainWindow(QWidget *parent)
	: QMainWindow(parent)
{
	QMenuBar *bar = menuBar();
	QAction *action;
	QSettings settings("igorinov", "ameter", this);

	g_n = settings.value("g", g_n).toDouble();
	a_max = settings.value("max", a_max).toDouble();
	divisions = settings.value("divisions", divisions).toInt();
	angle_step = settings.value("angle_step", angle_step).toInt();
	smoothing = settings.value("smoothing", smoothing).toInt();
	data_rate = settings.value("rate", data_rate).toInt();

	awidget = new AMeterWidget(this);
	setCentralWidget(awidget);
	action = bar->addAction("&About");
	connect(action, SIGNAL(triggered()), this, SLOT(showAbout()));
	action = bar->addAction("&Settings");
	connect(action, SIGNAL(triggered()), this, SLOT(showSettings()));
	accelerometer = new QAccelerometer(this);
	accelerometer->setProperty("alwaysOn", true);
	accelerometer->addFilter(awidget);
	accelerometer->setDataRate(data_rate);
	accelerometer->start();

#ifdef Q_WS_MAEMO_5
	dBusInterface = new QDBusInterface(MCE_SERVICE, MCE_REQUEST_PATH,
		MCE_REQUEST_IF, dBusConnection, this);
 
	dBusConnection.connect(MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF,
		MCE_DISPLAY_SIG, this, SLOT(screenChange(const QDBusMessage &)));
#endif
}

MainWindow::~MainWindow()
{
	delete awidget;
	delete accelerometer;
}

void MainWindow::showAbout()
{
	AboutDialog dialog(this);

	dialog.exec();
}

void MainWindow::showSettings()
{
	SettingsDialog dialog(this);
	QSettings settings("igorinov", "ameter", this);
	int code;

	accelerometer->stop();
	code = dialog.exec();
	accelerometer->start();
	if (code != QDialog::Accepted)
	{
		return;
	}
	
	settings.setValue("g", g_n);
	settings.setValue("max", a_max);
	settings.setValue("divisions", divisions);
	settings.setValue("angle_step", angle_step);
	settings.setValue("rate", data_rate);

	awidget->setGravity(g_n);
	accelerometer->setDataRate(data_rate);
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

#ifdef Q_WS_MAEMO_5
void MainWindow::screenChange(const QDBusMessage &message)
{
    QString state = message.arguments().at(0).toString();
    if (!state.isEmpty()) {
        if (state == MCE_DISPLAY_OFF_STRING)
        {
            accelerometer->stop();
	    awidget->reset();
        } else {
            accelerometer->start();
        }
    }
}
#endif

