#include <QtCore/QFile>
#include <QtGui/QPainter>

#include <math.h>

#include "ameterwidget.h"

#define SET_IM_STATUS 1

AMeterWidget::AMeterWidget(QWidget *parent)
    : QWidget(parent)
{
	// Reciprocal of gravity
	rg = 1.0 / G_N;
//    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(tick()));
//	timer->start(250);
	image = 0;

	ax = 0;
	ay = 0;
	az = 0;

	bx = 0;
	by = 0;
	bz = 0;

	status = 2;
	telepathist = new Telepathist(this);
	tt = 0;

	m_sensor = new QAccelerometer(this);
	m_sensor->addFilter(this);
	m_sensor->start();
}

AMeterWidget::~AMeterWidget()
{

}

void AMeterWidget::paintEvent(QPaintEvent *e)
{
    QPainter paint(this);
    qreal cx, cy, rx, ry;
    qreal x1, y1, a;

    a = sqrt(ax * ax + ay * ay + az * az);

    if (image)
    {
        paint.drawImage(QPoint(0, 0), *image);
    }

    paint.setRenderHints(QPainter::Antialiasing);

    cx = width() / 2;
    cy = height() / 2;
    rx = cy / 2;
    ry = cy / 2;

    x1 = cx - ax * rx;
	y1 = cy + ay * ry;

    paint.setPen(QPen(QBrush(QColor(255, 255, 255, 255)), 1));
    paint.setBrush(QBrush(QColor(255, 255, 255, 255)));
    paint.drawEllipse(QPointF(x1, y1), 3, 3);
    paint.drawLine(QPointF(cx, cy), QPointF(x1, y1));
}

void AMeterWidget::resizeEvent(QResizeEvent *e)
{
    QPainter *paint;
    qreal cx, cy, rx, ry;

    if (image)
    {
        delete image;
        image = 0;
    }

    image = new QImage(size(), QImage::Format_ARGB32);
    paint = new QPainter(image);
    paint->setRenderHints(QPainter::Antialiasing);

    cx = width() / 2;
    cy = height() / 2;
    rx = cy / 2;
    ry = cy / 2;

	paint->setPen(QPen(QBrush(QColor(64, 64, 64, 255)), 3));

    paint->drawLine(QPointF(cx, 0), QPointF(cx, cy + cy));
    paint->drawLine(QPointF(0, cy), QPointF(cx + cx, cy));

    paint->drawEllipse(QPointF(cx, cy), rx, ry);
    paint->drawEllipse(QPointF(cx, cy), 2 * rx, 2 * ry);
    paint->drawEllipse(QPointF(cx, cy), 3 * rx, 3 * ry);
    paint->drawEllipse(QPointF(cx, cy), 4 * rx, 4 * ry);

    paint->setPen(QPen(QBrush(QColor(64, 64, 64, 255)), 1));

	paint->drawLine(QPointF(cx - cx, cy + cx), QPointF(cx + cx, cy - cx));
	paint->drawLine(QPointF(cx - cx, cy - cx), QPointF(cx + cx, cy + cx));

	paint->drawEllipse(QPointF(cx, cy), 0.25 * rx, 0.25 * ry);
	paint->drawEllipse(QPointF(cx, cy), 0.50 * rx, 0.50 * ry);
	paint->drawEllipse(QPointF(cx, cy), 0.75 * rx, 0.75 * ry);

	paint->drawEllipse(QPointF(cx, cy), 1.25 * rx, 1.25 * ry);
	paint->drawEllipse(QPointF(cx, cy), 1.50 * rx, 1.50 * ry);
	paint->drawEllipse(QPointF(cx, cy), 1.75 * rx, 1.75 * ry);

	paint->drawEllipse(QPointF(cx, cy), 2.25 * rx, 2.25 * ry);
	paint->drawEllipse(QPointF(cx, cy), 2.50 * rx, 2.50 * ry);
	paint->drawEllipse(QPointF(cx, cy), 2.75 * rx, 2.75 * ry);


	paint->drawEllipse(QPointF(cx, cy), 3.25 * rx, 3.25 * ry);
	paint->drawEllipse(QPointF(cx, cy), 3.50 * rx, 3.50 * ry);
	paint->drawEllipse(QPointF(cx, cy), 3.75 * rx, 3.75 * ry);

    delete paint;
}

bool AMeterWidget::filter(QAccelerometerReading *reading)
{
	ax = reading->x() * rg;
	ay = reading->y() * rg;
	az = reading->z() * rg;

	update();

	return true;
}

void AMeterWidget::tick()
{
    char strbuf[128];
    int x, y, z;
    QFile *f;

	bx = ax;
	by = ay;
	bz = az;

    f = new QFile("/sys/class/i2c-adapter/i2c-3/3-001d/coord");
    if (f->open(QFile::ReadOnly))
    {
        f->read(strbuf, 127);
        if (sscanf(strbuf, "%d %d %d", &x, &y, &z) == 3)
        {
            ax = x * 0.001;
            ay = y * 0.001;
            az = z * 0.001;
        }
    }
    delete f;

#ifdef SET_IM_STATUS

	if (fabs(ax - bx) > 0.125 || fabs(ay - by) > 0.125 || fabs(az - bz) > 0.125)
	{
		tt = 0;
		if (status != 2)
		{
			telepathist->setStatus(2, "available", "In the pocket");
			status = 0;
		}
	} else {
		tt++;
	}

	if (tt == 480)
	{
		telepathist->setStatus(3, "away", "Fishing");
		status = 3;
	}

#endif

    update();
}
