#!/bin/bash

# only do stuff if tweaker is actually installed
if ! (dpkg -l tweakr | grep '^ii' >/dev/null 2>&1); then
    echo "tweakr not installed"
    exit 1
fi

PROFILE="$1"
PROFILES=$(gconftool-2 --all-dirs /system/tweakr|cut -d'/' -f4)
DBUSSET="dbus-send --print-reply --dest='com.nokia.profiled' /com/nokia/profiled com.nokia.profiled.set_value string:general string:\'%s\' string:\'%s\'"

# check if profile exists
okflag=0
for p in ${PROFILES}
do
    if [ "${PROFILE}" == "$p" ]; then
        okflag=1
        break
    fi
done

if [ ${okflag} -ne 1 ]; then
    echo "No such profile: ${PROFILE}"
    exit 1
fi

# set tweakr profile
gconftool-2 --set /system/tweakr/current-preset "${PROFILE}" --type=string &>/dev/null

# set all values
gconftool-2 -a /system/tweakr/Sleep|sed 's/^ //'|sed 's/ = /=/'|awk -F'=' "{cmd=sprintf(\"${DBUSSET}\", \$1, \$2);system(cmd)}" &>/dev/null

# switch to profile general
dbus-send --print-reply --dest='com.nokia.profiled' /com/nokia/profiled com.nokia.profiled.set_profile string:general &>/dev/null
