import QtQuick 1.0
import QtMultimediaKit 1.1
import "storage.js" as Storage

Rectangle {
    id: rect3
    width: flickaBool.contentWidth
    height: 480
    color: "black"
    radius: 0
    clip: false
    Item{
        Loader{ y: 1000;id: settingsLoader; source: ""; width: 400; height: 200}
    }

Flickable {
    id: flickaBool

height: 480
width: 800
contentWidth: 1600
boundsBehavior: Flickable.StopAtBounds
/////////////////////////////////////////////////////Settings///////////////////////////////////////////
/////////////////////////////////////////////////////Settings///////////////////////////////////////////



flickableDirection: Flickable.HorizontalFlick


////////////////////////////////////////Views///////////////////////////////////////////////////////////////


    ListView {
        id: artistView
        x: 0
        clip: true
        y: 56
        visible: true
        ScrollBar {
               flickable: artistView
               color: "white"
               vertical: true
           }
        smooth: false
        cacheBuffer: 2500
        width: 200
        height: 400
        anchors.left: parent.left
        anchors.leftMargin: 0
        focus: false
        Keys.onRightPressed: albumList.focus = true
        model: artistModel
        snapMode: "SnapToItem"

        delegate:
            Rectangle{

                        id: borderrr
                        width: 200
                        height: 100
                        clip: false
                        gradient: Gradient {
                            GradientStop { position: 0.0; color: "white" }
                            GradientStop { position: 0.01; color: "black" }

                                     GradientStop { position: 0.99; color: "black" }
                                     GradientStop { position: 1.0; color: "white" }
                        }

                        opacity: 1
                        radius: 0

                        MouseArea {
                            id: mousyyy
                           anchors.fill: borderrr
                           onClicked: yoyoModel.source = Storage.getSetting("serverZ") + "/rest/getMusicDirectory.view?u=" + Storage.getSetting("userNamez") + "&p=" + Storage.getSetting("passWord") + "&v=1.5&c=Aerofy&id=" + artistId
                       }


            Text {
            id: artist
            height: parent.height
            smooth: false
            clip: true
            opacity: 1
            color: "white"
            anchors.top: parent.top; anchors.topMargin: 13
            font.pointSize: 14
            text: artistName


        Text {
            id: artistid
            text: artistId
            visible: false
        }
    }
        }
    }
    ListView {
        id: albumList
        x: 200
        y: 56
        width: 300
        height: 400
        ScrollBar {
               flickable: albumList
               color: "white"
               vertical: true
           }
        clip: true
        maximumFlickVelocity: 1200
        flickDeceleration: 300
        visible: true
        snapMode: "SnapToItem"

        model: yoyoModel

        delegate:     Rectangle{
            anchors.left: parent.left
            anchors.leftMargin: 20

                        id: borderrr
                        height: 100
                        width: 300
                        gradient: Gradient {
                            GradientStop { position: 0.0; color: "white" }
                            GradientStop { position: 0.01; color: "black" }

                                     GradientStop { position: 0.99; color: "black" }
                                     GradientStop { position: 1.0; color: "white" }
                        }

                        opacity: 1
                        radius: 0

            Text {
            id: album
            text: albumName
            height: parent.height
            width: 200
            color: "white"
            elide: Text.ElideRight
            anchors.top: parent.top; anchors.topMargin: 13
            font.pointSize: 14
            MouseArea {
                id: mouseLike
               anchors.fill: album
               onClicked: songModel.source = Storage.getSetting("serverZ") + "/rest/getMusicDirectory.view?u=" + Storage.getSetting("userNamez") + "&p=" + Storage.getSetting("passWord") + "&v=1.5&c=Aerofy&id=" + albumId
           }
        Text {
            id: albumid
            text: albumId
            anchors.left: album.right; anchors.leftMargin: 30
            opacity: 0.0

        }
    }
    }
}


    ListView {
        id: songList
        x: 538
        y: 56
        width: 217
        opacity: 1
        height: 400
        ScrollBar {
               flickable: songList
               color: "white"
               vertical: true
           }
        cacheBuffer: 10000
        highlight: Rectangle { color: "white"; opacity: 1}
        clip: true
        snapMode: "SnapToItem"
            preferredHighlightBegin: 0; preferredHighlightEnd: 0  //this line means that the currently highlighted item will be central in the view
             highlightFollowsCurrentItem: true  //updates the current index property to match the currently highlighted item
        maximumFlickVelocity: 1200
        flickDeceleration: 300
        visible: true

        model: songModel

        delegate:    Rectangle{

                        id: borderrrrr
                        width: 330
                        height: 100
                        opacity: 0.8
                        gradient: Gradient {
                            GradientStop { position: 0.0; color: "white" }
                            GradientStop { position: 0.01; color: "black" }

                                     GradientStop { position: 0.99; color: "black" }
                                     GradientStop { position: 1.0; color: "white" }
                        }

                        radius: 0
                        MouseArea{
                            id: playMouse
                            anchors.fill: borderrrrr
                            onClicked: {songList.currentIndex = index; playListModel.append({"Name" :songList.model.get(songList.currentIndex).songName, "Id" : songList.model.get(songList.currentIndex).songId, "Artist" : songList.model.get(songList.currentIndex).songArtist })}
                        }


            Text {
            id: song
            text: songName
            opacity: 1
            height: parent.height
            color: "white"
            width: 300
            font.pointSize: 13
            anchors.top: parent.top; anchors.topMargin: 13
            elide: "ElideRight"
            Text { id: songDura; text: songDuration; color: "white"; anchors.top: parent.top; anchors.topMargin: 28; visible: false}

        Text {
            id: songid
            text: songId
            anchors.left: song.right; anchors.leftMargin: 30
            visible: false

        }
         }
    }
}
    ListView {
        id: playListView
        x: 840
        clip: true
        y: 56
        width: 500
        height: 400
        model: playListModel
        delegate: Rectangle{

            id: borderrrrr
            width: 500
            height: 100
            opacity: 0.8
            gradient: Gradient {
                GradientStop { position: 0.0; color: "white" }
                GradientStop { position: 0.01; color: "black" }

                         GradientStop { position: 0.99; color: "black" }
                         GradientStop { position: 1.0; color: "white" }
            }

            radius: 0
            Text { text: Artist; color: "white"; anchors.top: parent.top; anchors.topMargin: 6; height: parent.height; width: 500;             font.pointSize: 13}
                MouseArea{anchors.fill: parent; onClicked: {playListView.currentIndex = index; songPlay.playing ? songPlay.stop() : songPlay.play()}}
            Text { text: Name; color: "white"; anchors.top: parent.top; anchors.topMargin: 60; height: parent.height; width: 500;             font.pointSize: 13
        Text { text: Id; color: "white"; anchors.left: parent.right; anchors.leftMargin: 5; opacity: 0}

        }
    }
    }


 ////////////////////////////////////////Views///////////////////////////////////////////////////////////////






////////////////////////////////////////Models///////////////////////////////////////////////////////////////
        XmlListModel {
                    id: artistModel
                    source: Storage.getSetting("serverZ") + "/rest/getIndexes.view?u=" + Storage.getSetting("userNamez") + "&p=" + Storage.getSetting("passWord") + "&v=1.5&c=Aerofy"
                    query: "/subsonic-response/indexes/index/artist"
                    namespaceDeclarations: "declare default element namespace 'http://subsonic.org/restapi';"




                    XmlRole { name: "artistName"; query: "@name/string()" }
                    XmlRole { name: "artistId"; query: "@id/string()" }
            }


        XmlListModel {
                id: yoyoModel
                source: ""
                query: "/subsonic-response/directory/child"
                namespaceDeclarations: "declare default element namespace 'http://subsonic.org/restapi';"




                XmlRole { name: "albumName"; query: "@title/string()" }
                XmlRole { name: "albumId"; query: "@id/string()" }
                XmlRole { name: "trackNum"; query: "@coverArt/string()" }


        }

        XmlListModel {
                id: songModel
                source: ""
                query: "/subsonic-response/directory/child"
                namespaceDeclarations: "declare default element namespace 'http://subsonic.org/restapi';"




                XmlRole { name: "songName"; query: "@title/string()" }
                XmlRole { name: "songId"; query: "@id/string()" }
                XmlRole { name: "songDuration"; query: "@duration/string()" }
                XmlRole { name: "songArtist"; query: "@artist/string()" }

        }

        ListModel{
            id: playListModel
        }



  ////////////////////////////////////////////Models/////////////////////////////////////////////////////////////






Text {
    id: text1
    x: 221
    y: -9
    width: 200
    height: 50
    color: "#ffffff"
    text: "Albums"
    z: 27
    verticalAlignment: Text.AlignVCenter
    font.pixelSize: 40
}

Text {
    id: text2
    x: 538
    y: 0
    width: 80
    Text { anchors.left: parent.right; anchors.leftMargin: 230; text: "Playlist"; color: "white"; font.pixelSize: 40}
    height: 20
    color: "#ffffff"
    text: "Songs"
    font.pixelSize: 40;Component.onCompleted: {
        // Initialize the database
        Storage.initialize();
        // Sets a value in the database
        Storage.setSetting("userName",text3.text);
        // Sets the textDisplay element's text to the value we just set
    }
}

Text {
    id: text3
    x: 0
    y: 0
    color: "#ffffff"
    text: "Artists"
    font.pixelSize: 40
    states: State {
        name: "moved"
        PropertyChanges {
            target: bottomBar
            y: 370
        }
        PropertyChanges {
            target: rect3
            y: -40
        }
        PropertyChanges {
            target: artistView
            opacity: 0.5
        }
        PropertyChanges {
            target: albumList
            opacity: 0.5
        }
        PropertyChanges {
            target: songList
            opacity: 0.5
        }
}
    transitions: Transition {
        SmoothedAnimation { properties: "y"; velocity: 200; easing{type: Easing.OutQuad; overshoot: 1000} }
    }
    }
}
Audio {
    id: songPlay
    paused: false
    playing: false
    autoLoad: false
   source: Storage.getSetting("serverZ") + "/rest/stream.view?u=" + Storage.getSetting("userNamez") + "&p=" + Storage.getSetting("passWord") + "&v=1.5&c=Aerofy&id=" + playListView.model.get(playListView.currentIndex).Id
   onStopped: {if (songPlay.status =="7") playListView.currentIndex = playListView.currentIndex+1,songPlay.play(); else songPlay.play()}
   onStarted: if (songPlay.status == "4") console.log("Loading")
}
Rectangle {
    id: bottomBar
    x: 0
    y: 455
    states: State {
        name: "settings"
        PropertyChanges {
            target: settingsLoader
            source: "Settings.qml"
        }
        PropertyChanges {
            target: settingsLoader
            y: 0
        }
        PropertyChanges {
            target: artistView
            visible: false
        }
        PropertyChanges {
            target: albumList
            visible: false
        }
        PropertyChanges {
            target: songList
            visible: false
        }
        PropertyChanges {
            target: flickaBool
            interactive: false
        }
        PropertyChanges {
            target: playListView
            visible: false
        }
        PropertyChanges {
            target: text3
            visible: false
        }
        PropertyChanges {
            target: text2
            visible: false
        }
        PropertyChanges {
            target: text1
            visible: false
        }

    }
    transitions: Transition {
        SmoothedAnimation { properties: "y"; velocity: 1600; easing{type: Easing.OutQuad; overshoot: 1000} }
    }
    width: 800
    Image{ source: Storage.getSetting("serverZ") + "/rest/getCoverArt.view?u=" + Storage.getSetting("userNamez") + "&p=" + Storage.getSetting("passWord") + "&v=1.5&c=Aerofy&id=" + playListView.model.get(playListView.currentIndex).Id; width: 120; height: 120; anchors.top: parent.top;anchors.topMargin: 8; anchors.left: parent.left;anchors.leftMargin: 8}
    radius: 5
    color: "white"
    height: 143
    MouseArea { id: artistHide; x: 0; y: 0; width: 1057; height: 143; anchors.rightMargin: -257; anchors.topMargin: 0; anchors.fill: parent; onClicked: if (text3.state == "")
                                                                    text3.state = "moved"
        else
                                                                    text3.state = ""
    }
    Image {id: bigRect; anchors.centerIn: parent;  source: "qrc:/playicon.png"; states: State {
            name: "pause"
            PropertyChanges {
                target: songPlay
                paused: true
            }
        }
        MouseArea { id: playButton;anchors.fill: parent; onClicked: if (bigRect.state == "")
                                                                        bigRect.state = "pause"
            else
                                                                        bigRect.state = ""}

        Image { anchors.left: parent.right;anchors.leftMargin: 5;y:30; source: "qrc:/righticon.png"
            MouseArea { anchors.fill: parent; onClicked: {playListView.currentIndex = playListView.currentIndex+1; songPlay.stop(); songPlay.play()}}}
        Image { anchors.right: parent.left;anchors.rightMargin: 5; y:30; source: "qrc:/lefticon.png"
                MouseArea { anchors.fill: parent; onClicked: { playListView.currentIndex = playListView.currentIndex-1; songPlay.stop(); songPlay.play()}}}

            Rectangle { anchors.left: parent.right;anchors.leftMargin: 100;y: 30; width: 100; height:  100; color: "black"; radius: 10
                Text { id: playListClear; anchors.centerIn: parent; text: "Clear" ;font.pointSize: 23; color: "white"}

                MouseArea { anchors.fill: parent; onClicked: playListModel.clear()
                    Rectangle { anchors.left: parent.right;anchors.leftMargin: 10;  width: 100; height:  100; color: "black"; radius: 10
                        Text { id: settingsMenu; anchors.centerIn: parent; text: "Settings" ;font.pointSize: 21; color: "white"}

                        MouseArea { anchors.fill: parent; onClicked: if (bottomBar.state == "")
                                                                         bottomBar.state = "settings"
             else
                                                                         bottomBar.state = ""}
                       }


                    }}}}}



