#!/usr/bin/env python
'''
Created on 1.10.2011

@author: Kotiacco
'''
 
import gtk
import hildon
import socket

from rpc import RPC
global window

def op1event(self, conn):
    conn.server.shutdownServer()

def op2event(self, conn):
    conn.server.restartServer()
    
def op3event(self, conn):
    plcount = conn.server.getOnlinePlayers()
    hildon.hildon_banner_show_information(window, '', 'There are %(1)s players online.' % {"1":plcount})
    
def op4event(self, conn):
    ccount = conn.server.getMaximumConnections()
    hildon.hildon_banner_show_information(window, '', 'Current connection cap is %(1)s.' % {"1":ccount})

def op5event(op5, conn):
    val = op5.get_value()
    print val
    conn.server.setMaximumConnections(int(val))

def createUI(conn):
    vbox = gtk.VBox(False, 0)
    vbox.pack_start(connText, False, False, 0)
    
    #Add buttons to vertical box
    op1 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Shutdown Server")
    op1.connect("clicked", op1event, conn)
    vbox.pack_start(op1, True, True, 0)
    
    op2 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Restart Server")
    op2.connect("clicked", op2event, conn)
    vbox.pack_start(op2, True, True, 0)
    
    op3 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Get online players count")
    op3.connect("clicked", op3event, conn)
    vbox.pack_start(op3, True, True, 0)
    
    op4 = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Get connection cap")
    op4.connect("clicked", op4event, conn)
    vbox.pack_start(op4, True, True, 0)
    
    op5 = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
    op5.set_title("Set connection cap")
    selector = hildon.TouchSelectorEntry(text=True)
    for r in range(10):
        selector.append_text(str(r*10))
    # Attach the touch selector to the picker button
    op5.set_selector(selector)
    op5.connect("value-changed", op5event, conn)
    vbox.pack_start(op5, True, True, 0)
    
    return vbox

def main(): 
    global connText, window

    socket.setdefaulttimeout(10)
    
     #Create window and widgets    
    window = hildon.StackableWindow ()
    window.set_title ("Aegis Online Admin")
    window.connect("destroy", gtk.main_quit)

    #Connect to server    
    connText = gtk.Label("")
    try:
        conn = RPC("http://aegis-enigma.zapto.org:8080/aeweb")
        if conn.isReady() == True:
            connText.set_text("Connected to the server")
        
            pan = hildon.PannableArea()
            pan.add_with_viewport(createUI(conn))
    
            window.add(pan)
        else:
            connText.set_text("Failed to connect to server")
            window.add(connText)
    except:
        print 'fail'    
    
    window.show_all()
    gtk.main()
if __name__ == '__main__':
    main()