#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <phonon/MediaObject>
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkAccessManager>
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5/QMaemo5InformationBox>
#endif
#include "settingsdialog.h"
#include "parser.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void reloadJson();
    void readJson(QNetworkReply* reply);
    void lastAdvice();
    void copyLink();
    void say();
    void options();
    void about();

private:
    QLabel *adviceLabel;
    QPushButton * okButton;
    QAction *lastAction;
    QAction *copyAction;
    QAction *sayAction;
    QAction *optionsAction;
    QAction *aboutAction;

    QNetworkAccessManager* manager;
    QByteArray json;
    int id;
    QString sound;
    QSettings settings;
    Phonon::MediaObject *audio;

    void renewAdvice();
};

#endif // MAINWINDOW_H
