#
# Original program copyright 2010 Ruediger Gad <r.c.g@gmx.de>
# Modified by Skyler Lehmkuhl
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math
import time
import clock
from pythonwifi.iwlibs import Wireless


def get_name():
    return "Binary Clock with Color and Speedometer"

class binclockspeed(clock.Clock):
    def __init__(self, drawing_area, interval=0.1, percentage=True):
        clock.Clock.__init__(self, drawing_area)
        self.interval=interval
        self.percentage=percentage
        self.result=self.compute()

    def draw_bits_horizontally(self, x, y, radius, value, n, reverse=False, color=None):
        for i in range(n):
            if reverse:
                self.context.set_source_rgb(color, value/60.0, i/6.0)
                self.context.arc(x + (1.5 * radius) + (3 * radius * (n-i)), y + radius, radius, 0, 2 * math.pi)
            else:
                self.context.set_source_rgb(y/26.0, value/60.0, i/6.0)
                self.context.arc(x + (1.5 * radius) + (3 * radius * i), y + radius, radius, 0, 2 * math.pi)
            if (value >> (n - i - 1) & 1) > 0:
                self.context.fill_preserve()
            self.context.stroke()

    def get_connection_speed(self, interface, rxtx="rx"):
        try:
            recordedspeed = open('/tmp/internet_speed_'+interface+"_"+rxtx, 'r')
            last = recordedspeed.read()
            recordedspeed.close()
            print last
        except:
            last = 0
        recordedspeed = open('/tmp/internet_speed_'+interface+"_"+rxtx, 'w')
        procspeed = open('/proc/net/dev', 'r')
        currentspeed = procspeed.read().split()
        for i in range(len(currentspeed)):
            if currentspeed[i].startswith(interface):
                if rxtx=="rx":
                    now = currentspeed[i+1]
                else:
                    now = currentspeed[i+9]
        recordedspeed.write(now)
        recordedspeed.close()
        procspeed.close()
        return(int(now)-int(last))
        
    def spd2bin(self):
        wlanrx = self.get_connection_speed('wlan0')
        wmasterrx = self.get_connection_speed('wmaster0')
        phonetrx = self.get_connection_speed('phonet0')
        speedrx = (wlanrx+wmasterrx+phonetrx)
        wlantx = self.get_connection_speed('wlan0', 'tx')
        wmastertx = self.get_connection_speed('wmaster0', 'tx')
        phonettx = self.get_connection_speed('phonet0', 'tx')
        speedtx = (wlantx+wmastertx+phonettx)
        return (int(math.log(speedrx+1)*math.log(speedrx+1)/5), math.log(speedtx+1)*math.log(speedtx+1)/300.0)

    def wifi_level(self):
        wifi = Wireless('wlan0')
        return wifi.getStatistics()[1].getSignallevel()/8

    def draw_clock(self):
        if self.show_seconds :
            self.draw_bits_horizontally(12, 2, 4, self.time.hour, 5)
            self.draw_bits_horizontally(0, 14, 4, self.time.minute, 6)
            self.draw_bits_horizontally(0, 26, 4, self.time.second, 6)
        else :
            self.draw_bits_horizontally(18, 2, 6, self.time.hour, 5)
            self.draw_bits_horizontally(0, 20, 6, self.time.minute, 6)
        down, up = self.spd2bin()
        self.draw_bits_horizontally(70, 2, 4, down, 6, True, up)
        self.draw_bits_horizontally(70, 14, 4, int(self.compute()/2), 6, True, 0.5)
        self.draw_bits_horizontally(70, 26, 4, self.wifi_level(), 6, True, 1.0)
        

    def resize(self):
        if self.show_seconds :
            self.drawing_area.set_size_request(166, 36)
        else:
            self.drawing_area.set_size_request(186, 36)
      
    def get_time(self):
        stat_file=file("/proc/stat", "r")
        time_list=stat_file.readline().split(" ")[2:6]
        stat_file.close()
        for i in range(len(time_list))  :
            time_list[i]=int(time_list[i])
        return time_list
  
    def delta_time(self):
        x=self.get_time()
        time.sleep(self.interval)
        y=self.get_time()
        for i in range(len(x)):
            y[i]-=x[i]
        return y   

    def compute(self):
        t=self.delta_time()
        if self.percentage:
            result=100-(t[len(t)-1]*100.00/sum(t))
        else:
            result=float(sum(t))
        return result
