#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "Binary Clock with Color"

class BinaryClockColor(clock.Clock):
    def __init__(self, drawing_area):
        clock.Clock.__init__(self, drawing_area)

    def draw_bits_horizontally(self, x, y, radius, value, n):
        for i in range(n):
            self.context.set_source_rgb(y/26.0, value/60.0, i/6.0)
            self.context.arc(x + (1.5 * radius) + (3 * radius * i), y + radius, radius, 0, 2 * math.pi)
            if (value >> (n - i - 1) & 1) > 0:
                self.context.fill_preserve()
            self.context.stroke()

    def draw_clock(self):
        if self.show_seconds :
            self.draw_bits_horizontally(12, 2, 4, self.time.hour, 5)
            self.draw_bits_horizontally(0, 14, 4, self.time.minute, 6)
            self.draw_bits_horizontally(0, 26, 4, self.time.second, 6)
        else :
            self.draw_bits_horizontally(18, 2, 6, self.time.hour, 5)
            self.draw_bits_horizontally(0, 20, 6, self.time.minute, 6)

    def resize(self):
        if self.show_seconds :
            self.drawing_area.set_size_request(76, 36)
        else:
            self.drawing_area.set_size_request(110, 36)

