#
# Original program copyright 2010 Ruediger Gad <r.c.g@gmx.de>
# Modified 2010 by Skyler Lehmkuhl
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "BCD Clock with Color"

class BcdClockColor(clock.Clock):
    def __init__(self, drawing_area):
        clock.Clock.__init__(self, drawing_area)

    def draw_bits_vertically(self, x, y, radius, value, n):
        for i in range(n):
            if n==2:
                self.context.set_source_rgb(x/36.0, 
value/2.0, i/(n*1.0))
            else:
                self.context.set_source_rgb(x/36.0, 
value/10.0, i/(n*1.0))
            self.context.arc(x + radius, y + (1.5 * radius)  + (3 * radius * i), radius, 0, 2 * math.pi)
            if (value >> (n - i - 1) & 1) > 0:
                self.context.fill_preserve()
            self.context.stroke()

    def draw_clock(self):
        self.draw_bits_vertically(2, 18, 3, self.time.hour / 10, 2)
        self.draw_bits_vertically(12, 0, 3, self.time.hour % 10, 4)
        self.draw_bits_vertically(26, 9, 3, self.time.minute / 10, 3)
        self.draw_bits_vertically(36, 0, 3, self.time.minute % 10, 4)
        if self.show_seconds:
            self.draw_bits_vertically(50, 9, 3, self.time.second / 10, 3)
            self.draw_bits_vertically(60, 0, 3, self.time.second % 10, 4)

    def resize(self):
        if self.show_seconds :
            self.drawing_area.set_size_request(76, 36)
        else :
            self.drawing_area.set_size_request(47, 36)

