# -*- coding: utf-8 -*-
'''
UI Cachers
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import cairo, gtk

class AbstractCacher():

  def __init__(self):
    self.__cached = {}

  def cache(self, key, cache=True, force=False):
    if cache:
      if force:
        self.remove(key)
      if not key in self.__cached or self.__cached[key] == None:
        try:
          self.__cached[key] = self.cache_function(key)
        except Exception, e:
          self.__cached[key] = None
          return None
      return self.__cached[key].copy()
    else:
      return self.cache_function(key).copy()

  def get(self, key, cache=True, force=False):
    return self.cache(key, cache, force)

  def update(self, key):
    return self.cache(key, force=True)

  def remove(self, key):
    tmp = None
    if key in self.__cached:
      tmp = self.__cached[key]
      del self.__cached[key]
    return tmp

  def clear(self):
    self.__cached.clear()

  def cache_function(self, key):
    raise NotImplementedError('AbstractCacher.cache_function(key) must be implemented')

class ImageSurfaceFileCacher(AbstractCacher):
  def cache_function(self, filename):
    return cairo.ImageSurface.create_from_png(filename)

class PixbufFileCacher(AbstractCacher):
  def cache_function(self, filename):
    return gtk.gdk.pixbuf_new_from_file(filename)

class PixmapFileCacher(AbstractCacher):
  def cache_function(self, filename):
    pixbuf = gtk.gdk.pixbuf_new_from_file(filename)
    pixmap, mask = pixbuf.render_pixmap_and_mask()
    return pixmap

# DefaultIconThemePixbufCacher
class DITPixbufCacher(AbstractCacher):
  def __init__(self, size=64):
    self.__size = size
    self.__icon_theme = gtk.icon_theme_get_default()
    AbstractCacher.__init__(self)

  def cache_function(self, key):
    return self.__icon_theme.load_icon(key, self.__size, gtk.ICON_LOOKUP_NO_SVG)
