# -*- coding: utf-8 -*-
import gobject
from advifswlib.interfaces.Abstract import AbstractInterface

class GSMInterface(AbstractInterface):

  gsm_module_iface = 'com.nokia.phone.SSC'
  gsm_module_signal = 'modem_state_changed_ind'
  gsm_module_path = '/com/nokia/phone/SSC'

  def pre_init(self):
    self.state = {
    'name': 'GSM',
    'dbus': {
      'on': {'name': self.gsm_module_signal, 'iface': self.gsm_module_iface, 'path': self.gsm_module_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_cell_off', 'ifsw_statusarea_cell_on', 'ifsw_statusarea_cell_online'),
    'text': ('Off', 'On', '<>'),
    'show': (True, True, False),
    'banner': (True, False, True),
    'value': 0
    }
    self.interfaces = {'SSC': [self.gsm_module_iface, self.gsm_module_path, self.gsm_module_iface, '']}

  def process_signal_on(self, value):
    try:
      result = ['offline', 'activation_pending', 'online'].index(str(value))
    except:
      result = 0
    return result

  def get_status(self):
    try:
      result = ['offline', 'activation_pending', 'online'].index(str(self.get_interface('SSC').get_modem_state()))
    except:
      result = 0
    return result

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def run_commands(self, flag):
    self.get_interface('SSC').set_radio(flag)
    self.switched()
