# -*- coding: utf-8 -*-
import gtk, hildon, dbus
from advpowcommon.ui.Banners import HildonBanner
from advpowcommon.ui.Cachers import DITPixbufCacher
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.util.execn import *
from advifswlib.util.locale import *

class AbstractInterface():

  def __init__(self, bus=None, cb_status_area=None):
    self.__name = 'IFace'
    self.__processing = False
    self.__bus = bus
    self.__set_status_area_icon = cb_status_area
    self.__interfaces = {}
    self.__lcl = get_locale()
    self.interfaces = {}
    self.indication = 'on'
    self.state = {}

    self.pre_init()
    self.__name = self.state['name']

    self.__button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
    self.__button.set_image(gtk.Image())
    self.__button.set_image_position(gtk.POS_LEFT)
    self.__button.set_alignment(0.5,0.5,1,1)
    self.__button.set_image_alignment(0.5,0.5)
    self.__button.set_title_alignment(0,0.5)
    self.__button.set_value_alignment(0,0.5)
    self.__button.connect('clicked', self.__switch)
    self.__button.connect('destroy', self.__destroy)

    self.__smi_cacher = DITPixbufCacher(48)
    self.__smi_animator = DITPBCachedAnimator([], self.__button.get_image().set_from_pixbuf, cacher=self.__smi_cacher, time_out=250)

    self.start_animation()
    self.__init_interfaces()
    self.__get_status()
    self.__init_signals()
    self.stop_animation()

  def pre_init(self):
    pass

  def turn_on(self):
    pass

  def turn_off(self):
    pass

  def get_name(self):
    return self.__name

  def get_button(self):
    return self.__button

  def get_bus(self):
    return self.__bus

  def __destroy(self, button=None):
    self.__destroy_signals()
    self.__destroy_interfaces()

  def __init_signals(self):
    for key in self.state['dbus']:
      self.__init_signal(key)

  def __init_signal(self, x):
    try:
      def callback(*args, **kwargs): self.__received_signal(x, *args, **kwargs)
      setattr(self, 'received_%s' % x, callback)
      self.state['dbus'][x]['match'] = self.__bus.add_signal_receiver(
        getattr(self, 'received_%s' % x), 
        signal_name=self.state['dbus'][x]['name'], 
        dbus_interface=self.state['dbus'][x]['iface'], 
        path=self.state['dbus'][x]['path'], 
        **self.state['dbus'][x]['args'])
    except:
      pass

  def reinit_signal(self, x):
    self.__destroy_signal(x)
    self.__init_signal(x)

  def __destroy_signals(self):
    for key in self.state['dbus']: self.__destroy_signal(key)

  def __destroy_signal(self, x):
    receiver_match = self.state['dbus'][x]['match']
    self.__bus.clean_up_signal_match(receiver_match)
    self.__bus.remove_signal_receiver(receiver_match)
    receiver_match.remove()

  def __received_signal(self, key, *args, **kwargs):
    result = getattr(self, 'process_signal_%s' % key)(*args, **kwargs)
    if result != None and result != self.state['value']:
      self.state['value'] = result
      windex = self.state['value']
      if self.state['banner'][windex]:
        HildonBanner.show_information(self.__button, '%s: %s' % (self.__name, self.__lcl.get_item(self.state['text'][windex])))
      self.__update_ui()

  def __init_interfaces(self):
    for x in self.interfaces: self.__init_interface(x)

  def __init_interface(self, x, force=False):
    try:
      loaded = True
      if self.interfaces[x][3] and not force:
          loaded = get_shell_command_output('ps aux | grep \'%s\' | grep -v \'grep\' | awk {\'print $3\'}' % (self.interfaces[x][3])) != ''
      if loaded:
        self.__interfaces[x] = dbus.Interface(self.get_bus().get_object(self.interfaces[x][0], self.interfaces[x][1]), self.interfaces[x][2])
    except Exception, e:
      self.__interfaces[x] = None

  def reinit_interface(self, x, force=False):
    self.__destroy_interface(x)
    self.__init_interface(x, force)

  def get_interface(self, x):
    try:
      if self.__interfaces[x] == None:
        self.__init_interface(x)
      return self.__interfaces[x]
    except:
      return None

  def __destroy_interfaces(self):
    for x in self.interfaces: self.__destroy_interface(x)

  def __destroy_interface(self, x):
    try:
      self.__interfaces[x] = None
    except:
      pass

  def __get_status(self):
    self.state['value'] = getattr(self, 'get_status')()
    self.__update_ui()

  def switched(self):
    self.__processing = False
    self.stop_animation()

  def __update_ui(self):
    windex = self.state['value']
    self.__set_si(self.state['images'][windex])
    self.__button.set_value(self.__lcl.get_item(self.state['text'][windex]))

  def __switch(self, button=None, user_data=None):
    if not self.__processing:
      self.__processing = True
      try:
        self.start_animation()
        self.__button.set_value('...')
        if self.state['value']:
          self.turn_off()
        else:
          self.turn_on()
      except:
        self.switched()
        self.__update_ui()

  def start_animation(self):
    self.__smi_animator.start()

  def stop_animation(self):
    self.__smi_animator.stop()

  def __set_si(self, key):
    self.__set_smi(key)
    self.__set_sai(key)

  def __set_smi(self, key):
    self.__button.get_image().set_from_pixbuf(self.__smi_cacher.get(key))

  def __set_sai(self, key):
    if any(self.state['show']):
      if self.state['show'][self.state['value']]:
        self.__set_status_area_icon(self.__name, key)
      else:
        self.__set_status_area_icon(self.__name, None, False)
