# -*- coding: utf-8 -*-
'''
Interface Switcher Widget Config
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

try: #most distros have a separate gconf
  import gconf
except: #but Maemo doesn't
  from gnome import gconf

from advpowcommon.util.singleton import Singleton

class Config(Singleton):

  settings_path = '/apps/interface-switcher'

  def __init__(self):
    Singleton.__init__(self)
    self.__config = {}
    self.__gconf_client = gconf.client_get_default()
    self.__gconf_set = {'bool': self.__gconf_client.set_bool, 'int': self.__gconf_client.set_int, 'str': self.__gconf_client.set_string, 'long': self.__gconf_client.set_float}
    self.load()

  def save(self):
    self.__save()

  def __save(self):
    settings = self.__config
    for key in settings:
      self.save_settings_key(key)

  def get_keys(self):
    return self.__config.keys()

  def get_values(self):
    return self.__config.values()

  def get_key(self, key):
    try:
      return self.__config[key]['type'], self.__config[key]['value']
    except KeyError:
      return None, None

  def get_value(self, key):
    try:
      return self.__config[key]['value']
    except KeyError:
      return None

  def add_key(self, key_name, key_value=None):
    key_type = type(key_value)
    ctype = None
    if (key_type == str):
      ctype = 'str'
    elif (key_type == bool):
      ctype = 'bool'
    elif (key_type == int):
      ctype = 'int'
    elif (key_type == long):
      ctype = 'long'
    self.__config[key_name] = {'type': ctype, 'value': new_value}
    return self.__config[key_name]

  def set_value(self, key, new_value, callback=None):
    try:
      self.__config[key]['value'] = new_value
    except KeyError:
      self.add_key(key_name, new_value)
    if callback:
      callback(new_value)

  def save_key(self, key, callback=None):
    try:
      self.__gconf_set[self.__config[key]['type']](('/'.join(self.settings_path, key)), self.__config[key]['value'])
      if callback:
        callback(new_value)
    except KeyError:
      pass

  def load(self):
    self.__load_settings()

  def __load_settings(self):
    if not self.__gconf_client:
      return
    self.__config.clear()
    gconf_entries = self.__gconf_client.all_entries(self.settings_path)
    for entry in gconf_entries:
      name = entry.get_key().replace(('%s/' % self.settings_path), '', 1)
      e_value = entry.get_value()
      e_type = e_value.type
      value = None
      ctype = None
      if (e_type == gconf.VALUE_STRING):
        ctype = 'str'
        value = e_value.get_string()
      elif (e_type == gconf.VALUE_BOOL):
        ctype = 'bool'
        value = e_value.get_bool()
      elif (e_type == gconf.VALUE_INT):
        ctype = 'int'
        value = e_value.get_int()
      elif (e_type == gconf.VALUE_FLOAT):
        ctype = 'long'
        value = e_value.get_float()
      self.add_settings_key(name, ctype, value)

_config_singleton = Config()

def get_config(): return _config_singleton