# -*- coding: utf-8 -*-
import gobject, gtk, hildon
from hildondesktop import StatusMenuItem
import dbus
from dbus.mainloop.glib import DBusGMainLoop
from advpowcommon.ui.Cachers import DITPixbufCacher
from advpowcommon.ui.Animation import DITPBCachedAnimator
from ifaceswlib.interfaces.GSM import GSMInterface
from ifaceswlib.interfaces.BT import BTInterface
from ifaceswlib.interfaces.FlightMode import FlightMode
from ifaceswlib.interfaces.WLAN import WLANInterface
from ifaceswlib.util.config import *
from ifaceswlib.util.locale import *

class AdvancedInterfaceSwitcherMaemo5(StatusMenuItem):

  app_name= 'Advanced Interface Switcher'
  version = '0.3.5-1'
  dev_author = 'Kirill Plyashkevich'
  dev_email = 'ru.spirit@gmail.com'
  dev_years = '2010'

  def __init__(self):

    StatusMenuItem.__init__(self)
    self.__lcl = get_locale()
    self.__interfaces = []
    self.__animation_images = {}
    self.__config = get_config()
    self.__sai_cacher = DITPixbufCacher(18)
    self.__sai_animator = DITPBCachedAnimator([], self.set_status_area_icon, cacher=self.__sai_cacher, time_out=1000)
    self.__m_loop = DBusGMainLoop()
    self.__bus = dbus.SystemBus(mainloop = self.__m_loop, private = True)

    ifaces = (GSMInterface, BTInterface, WLANInterface)#, FlightMode)
    self.__smi_box = gtk.Table(len(ifaces), 1, True)
    self.add(self.__smi_box)
    ilist = enumerate(ifaces)

    loaded_list = ''
    loaded_ifaces = 0
    for iface in ilist:
      try:
        self.__interfaces.append(iface[1](self.__bus, self.process_sai))
        self.__smi_box.attach(self.__interfaces[iface[0]].get_button(), iface[0], iface[0]+1, 0, 1, gtk.EXPAND | gtk.FILL, gtk.SHRINK)
        loaded_ifaces += 1
        loaded_list = '%s\n%s' % (loaded_list, self.__interfaces[iface[0]].get_name())
      except Exception, e:
        print 'Error: %s' % (e)
    print 'Loaded (%s/%s):%s\n' % (loaded_ifaces, len(ifaces), loaded_list)

    self.show_all()

  def process_sai(self, iname, image='', add=True):
    if add:
      try:
        self.__sai_animator.remove_image(self.__animation_images[iname])
      except:
        pass
      self.__animation_images[iname] = image
      self.__sai_animator.add_image(image)
    else:
      try:
        image = self.__animation_images[iname]
        self.__sai_animator.remove_image(image)
      except:
        pass

  def __set_sai(self, key):
    self.set_status_area_icon(self.__sai_cacher.get(key))

def get_hd_plugin_type(): return InterfaceSwitcherMaemo5
