# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Abstract interface object
'''

import gtk, hildon, dbus
from advpowcommon.ui.Banners import HildonBanner
from advpowcommon.ui.Animation import DITPBCachedAnimator
from advpowcommon.ui.ToggleControl import ToggleControlMaemo5
from advpowcommon.util.execn import *
import advifswlib.util.cacher as cacher
import advifswlib.util.config as config
import advifswlib.util.locale as locale

class InterfaceState():
  off, on, connected, connecting, disconnecting = range(5)

class AbstractInterface():

  def __init__(self, bus=None, cb_status_area=None, 
               cb_show_settings_dialog=None):
    self.__name = 'IFace'
    self.__processing = False
    self.__bus = bus
    self.__set_status_area_icon = cb_status_area
    self.__show_settings_dialog = cb_show_settings_dialog
    self.__interfaces = {}
    self.__lcl = locale.get()
    self.interfaces = {}
    self.indication = 'on'
    self.state = {}
    self.__config = config.get()
    self.pre_init()
    self.__name = self.state['name']
    self.__config_path = 'settings/%s' % (self.__name.lower())
    self.__button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, 
                                  hildon.BUTTON_ARRANGEMENT_VERTICAL)
    self.__button.set_image(gtk.Image())
    #self.__button.set_image_position(gtk.POS_LEFT|gtk.POS_RIGHT)
    self.__button.set_alignment(0.5,0.5,1,1)
    #self.__button.set_image_alignment(0.5,0.5)
    #self.__button.set_title_alignment(0,0.5)
    #self.__button.set_value_alignment(0,0.5)
    self.__button.connect('clicked', self.__button_clicked)
    self.__button.tap_and_hold_setup(None, None, 0)
    self.__button.connect('tap-and-hold', self.__button_tap_and_hold)
    self.__button.connect('destroy', self.__destroy)
    self.__smi_cacher = cacher.get()
    self.__smi_animator = DITPBCachedAnimator([], 
                                              self.__button.get_image().set_from_pixbuf, 
                                              cacher=self.__smi_cacher, 
                                              time_out=250)
    self.state_control = None
    self.mode_control = None

    self.set_config_option('mode-on-startup', self.get_modes())

    self.start_animation()
    self.__init_interfaces()
    self.__get_status()
    self.__init_signals()
    self.stop_animation()

    self.post_init()

    start_state = int(self.get_config_value('enable-on-startup'))
    self.__switch_state(start_state)
    if start_state:
      self.__switch_mode(self.get_modes().index(self.get_config_value('mode-on-startup')))

    #print self.__name, self.state['value'], self.state['mode'], self.state['strength']
    #self.__show_switch_dialog()
    #self.__show_switch_dialog()

  def pre_init(self):
    pass

  def post_init(self):
    pass

  def turn_on(self):
    pass

  def turn_off(self):
    pass

  def get_name(self):
    return self.__name

  def get_button(self):
    return self.__button

  def get_bus(self):
    return self.__bus

  def get_modes(self):
    return list(self.state['modes'])

  def set_config_option(self, key, values):
    self.__config.set_option('%s/%s' % (self.__config_path, key), values)

  def get_config_value(self, key):
    return self.__config.get_value('%s/%s' % (self.__config_path, key))

  def set_config_value(self, key, value, save=False):
    return self.__config.set_value('%s/%s' % (self.__config_path, key), value, save)

  def destroy(self):
    self.__destroy()

  def __destroy(self, button=None):
    self.__destroy_signals()
    self.__destroy_interfaces()
    #print '%s (%s): destroyed' % (self.__name, self.__class__)

  def __init_signals(self):
    for key in self.state['dbus']:
      self.__init_signal(key)

  def __init_signal(self, x):
    try:
      def callback(*args, **kwargs): self.__received_signal(x, *args, **kwargs)
      setattr(self, 'received_%s' % x, callback)
      self.state['dbus'][x]['match'] = self.__bus\
                                       .add_signal_receiver(getattr(self, 'received_%s' % x), 
                                                            signal_name=self.state['dbus'][x]['name'], 
                                                            dbus_interface=self.state['dbus'][x]['iface'], 
                                                            path=self.state['dbus'][x]['path'], 
                                                            **self.state['dbus'][x]['args'])
      return True
    except:
      return False

  def reinit_signal(self, x):
    self.__destroy_signal(x)
    self.__init_signal(x)

  def __destroy_signals(self):
    for key in self.state['dbus']:
      self.__destroy_signal(key)

  def __destroy_signal(self, x):
    if 'match' in self.state['dbus'][x]:
      receiver_match = self.state['dbus'][x].pop('match')
      #self.__bus.clean_up_signal_match(receiver_match)
      self.__bus.remove_signal_receiver(receiver_match,
                                        signal_name=self.state['dbus'][x]['name'], 
                                        dbus_interface=self.state['dbus'][x]['iface'], 
                                        path=self.state['dbus'][x]['path']
                                       )
      receiver_match.remove()
      #print '%s: destroyed' % (x)
      return True
    return False

  def __received_signal(self, key, *args, **kwargs):
    #try: 
    value, mode, strength = getattr(self, 'process_signal_%s' % key)(*args, **kwargs)
    #except Exception, e: print 'Error: ', e
    show_banner = False
    update_ui = False
    if value != None and value != self.state['value']:
      self.state['value'] = value
      show_banner = True
      update_ui = True
      if self.state_control:
        self.state_control.set_active(value)
    if mode != None and mode != self.state['mode']:
      self.state['mode'] = mode
      show_banner = True
      if self.mode_control:
        self.mode_control.set_active(mode)
    if strength != None and strength != self.state['strength']:
      self.state['strength'] = strength
      update_ui = True
    if update_ui:
      self.__update_ui()
    windex = self.state['value']
    if self.get_config_value('show-popups') and show_banner and self.state['banner'][windex]:
      text = '%s: %s' % \
             (self.__name, self.__lcl.get(self.state['text'][windex]))
      if len(self.state['modes']) > 1:
        text = '%s (%s)' % \
               (text, self.__lcl.get_item(self.state['modes'][self.state['mode']]))
      HildonBanner.show_information(self.__button, text)
    #print self.__name, value, mode, strength

  def __init_interfaces(self):
    for x in self.interfaces:
      self.__init_interface(x)

  def __init_interface(self, x, force=False):
    try:
      loaded = True
      if self.interfaces[x][3] and not force:
          loaded = get_shell_command_output('ps aux | grep \'%s\' | grep -v \'grep\' | awk {\'print $3\'}' % 
                                            (self.interfaces[x][3])) != ''
      if loaded:
        self.__interfaces[x] = dbus.Interface(self\
                                              .get_bus()\
                                              .get_object(self.interfaces[x][0], 
                                                          self.interfaces[x][1], 
                                                          introspect=self.interfaces[x][4], 
                                                          follow_name_owner_changes=True), 
                                              self.interfaces[x][2])
      return True
    except Exception, e:
      del self.__interfaces[x]
      print e
      return False

  def reinit_interface(self, x, force=False):
    self.__destroy_interface(x)
    self.__init_interface(x, force)

  def get_interface(self, x):
    try:
      if not x in self.__interfaces:
        self.__init_interface(x)
      return self.__interfaces[x]
    except:
      return None

  def __destroy_interfaces(self):
    for x in self.interfaces:
      self.__destroy_interface(x)

  def __destroy_interface(self, x):
    try:
      del self.__interfaces[x]
      return True
    except:
      return False

  def __get_status(self):
    self.state['value'], self.state['mode'], self.state['strength'] = self.get_status()
    self.__update_ui()

  def switched(self):
    self.__processing = False
    self.stop_animation()

  def update(self):
    self.__update_ui()

  def __update_ui(self):
    value = self.state['value']
    image = self.state['images'][value]
    if value == InterfaceState.connected and self.state['strength'] > 0:
      image = self.state['images_st'][self.state['strength']]
    self.__set_si(image)
    self.__button.set_value(self.__lcl.get(self.state['text'][value]))

  def __button_clicked(self, button=None, user_data=None):
    return self.__switch(self.get_config_value('show-state-dialog'))

  def __button_tap_and_hold(self, button=None, user_data=None):
    return self.__switch(not(self.get_config_value('show-state-dialog')))

  def __switch(self, show_dialog):
    if not self.__processing:
      self.__processing = True
      self.start_animation()
      if show_dialog:
        gobject.idle_add(self.__show_switch_dialog)
      else:
        self.__switch_state(int(self.state['value'] == InterfaceState.off))
      self.__button.get_toplevel().hide()
    return True

  def __show_switch_dialog(self):
    settings_dialog = gtk.Dialog('%s' % (self.__name), None,#self.__button.window, 
                                 gtk.DIALOG_MODAL | gtk.DIALOG_NO_SEPARATOR, 
                                 (gtk.STOCK_PREFERENCES, gtk.RESPONSE_OK))
    self.state_control = ToggleControlMaemo5(self.__get_state_controls())

    self.state_control.set_active(self.__get_state_control_value())
    settings_dialog.vbox.pack_start(self.state_control.get_box(), True)
    height = self.state_control.get_height()

    if len(self.state['modes']) > 1:
      self.mode_control = ToggleControlMaemo5(self.__get_mode_controls())
      self.mode_control.set_active(self.state['mode'])
      settings_dialog.vbox.pack_start(self.mode_control.get_box(), True)
      height += self.mode_control.get_height()

    settings_button = settings_dialog.action_area.get_children()[0]
    settings_button.connect('clicked', self.__show_settings_dialog)

    #settings_dialog.vbox.set_size_request(-1, min(350, height))
    settings_dialog.show_all()
    self.__processing = False
    response = settings_dialog.run()
    if response == gtk.RESPONSE_DELETE_EVENT:
      #settings_dialog.destroy()
      self.state_control.destroy()
      self.state_control = None
      if self.mode_control:
        self.mode_control.destroy()
        self.mode_control = None
      settings_dialog.destroy()

  def __get_state_control_value(self):
    value = self.state['value']
    if value == InterfaceState.connecting:
      return InterfaceState.on
    elif value == InterfaceState.disconnecting:
      #return InterfaceState.connected
      return InterfaceState.on
    elif value == InterfaceState.connected:
      return InterfaceState.on
    return value

  def __get_state_controls(self):
    texts = map(self.__lcl.get, list(self.state['text'][:2]))
    return zip(texts, [self.__turn_state for t in texts])

  def __get_mode_controls(self):
    texts = map(self.__lcl.get_item, list(self.state['modes']))
    return zip(texts, [self.__turn_mode for t in texts])

  def __turn_state(self, widget=None, control=None, cstate=None):
    if widget.get_active():
      if not cstate:
        cstate = control.get_active()
      chstate = min(1, int(cstate))
      value = self.__get_state_control_value()
      if chstate != value:
        try:
          self.__switch_state(chstate)
        except:
          self.switched()
          self.__update_ui()
      elif cstate != value: 
        control.set_active(value)

  def __turn_mode(self, widget=None, control=None, cmode=None):
    if widget.get_active():
      if not(cmode):
        cmode = control.get_active()
      chmode = max(0, control.get_active())
      if self.state['value'] != InterfaceState.off and chmode != self.state['mode']:
        try:
          self.__switch_mode(chmode)
        except:
          self.switched()
          self.__update_ui()
      elif cmode != self.state['mode']: 
        control.set_active(self.state['mode'])

  def __switch_state(self, new_state):
    cstate = min(1, self.state['value'])
    new_state = max(0, min(new_state, len(self.state['text']) - 1))
    if new_state != cstate:
      self.__button.set_value('...')
      try:
        if new_state:
          self.turn_on()
        else:
          self.turn_off()
      except:
        self.switched()
        self.__update_ui()
    else:
      self.__processing = False

  def __switch_mode(self, new_mode):
    cmode = max(0, self.state['mode'])
    new_mode = max(0, min(new_mode, len(self.state['modes']) - 1))
    if new_mode != cmode:
      try:
        self.turn_mode(new_mode)
      except:
        self.switched()
        self.__update_ui()

  def turn_mode(self, mode):
    pass

  def start_animation(self):
    self.__smi_animator.start()

  def stop_animation(self):
    self.__smi_animator.stop()

  def __set_si(self, key):
    self.__set_smi(key)
    self.__set_sai(key)

  def __set_smi(self, key):
    self.__button.get_image().set_from_pixbuf(self.__smi_cacher.get(key))

  def __set_sai(self, key):
    if any(self.state['show']):
      #print self.__name, self.state['value'], self.state['show'][self.state['value']], self.get_config_value('show-sa-icon')
      if self.state['show'][self.state['value']] and self.get_config_value('show-sa-icon'):
        self.__set_status_area_icon(self.__name, key)
      else:
        self.__set_status_area_icon(self.__name, None, False)
