# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Bluetooth interface object
'''


import dbus, gobject
from advifswlib.interfaces.Abstract import InterfaceState, AbstractInterface
from advpowcommon.util.execn import *

class BTInterface(AbstractInterface):

  bt_adapter_iface = 'org.bluez.Adapter'
  bt_device_iface = 'org.bluez.Device'
  bt_adapter_signal = 'PropertyChanged'
  bt_device_signal = 'PropertyChanged'
  bt_adapter_path = get_shell_command_output('dbus-send --system --dest=org.bluez --print-reply / org.bluez.Manager.DefaultAdapter | tail -1 | sed \'s/^.*"\\(.*\\)".*$/\\1/\' 2>/dev/null')\
                    .replace('\n', '')
  bt_device_path = None

  def pre_init(self):
    self.state = {'name': 'Bluetooth',
                  'dbus': {'on': {'name': self.bt_adapter_signal, 
                                  'iface': self.bt_adapter_iface,
                                  'path': self.bt_adapter_path,
                                  'args': {}},
                           'connected': {'name': self.bt_device_signal, 
                                         'iface': self.bt_device_iface, 
                                         'path': self.bt_device_path, 
                                         'args': {'path_keyword': 'path'}}
                          },
                  'images': ('ifsw_statusarea_bluetooth_off', 
                             'ifsw_statusarea_bluetooth_on', 
                             'ifsw_statusarea_bluetooth_online'),
                  'images_st': ('ifsw_statusarea_bluetooth_online'),
                  'text': ('Off', 'On', '<>'),
                  'show': (False, True, True),
                  'banner': (True, True, True),
                  'value': InterfaceState.off,
                  'strength': 0,
                  'modes': ('bluetooth-connectable', 'bluetooth-discoverable'),
                  'mode': 0}
    self.interfaces = {'BlueZAdapter': ['org.bluez', self.bt_adapter_path, 
                                        self.bt_adapter_iface, '', True]}
    self.connected_device = set()

  def process_signal_connected(self, prop, value, **kwargs):
    if str(prop) == 'Connected':
      device = kwargs['path'].replace('%s/' % self.bt_adapter_path, '')
      if value:
        self.connected_device.add(device)
        return InterfaceState.connected, None, None
      else:
        try:
          self.connected_device.remove(device)
        except KeyError, e:
          pass
        if len(self.connected_device) == 0:
          return self.get_status()
    else:
      return None, None, None

  def process_signal_on(self, prop, value, **kwargs):
    prop = str(prop)
    if (prop == 'Powered'):
      if int(value):
        return InterfaceState.on, None, None
      else:
        return InterfaceState.off, None, None
    elif (prop == 'Discoverable'):
      return None, int(value), None
    else:
      return None, None, None

  def get_status(self):
    props = self.get_interface('BlueZAdapter').GetProperties()
    if props['Powered']:
      discoverable = int(props['Discoverable'])
      if int(props['Powered']):
        return InterfaceState.on, discoverable, 0
      else:
        return InterfaceState.off, discoverable, 0
    else:
      return 0, 0, 0

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    for device in self.connected_device:
      try:
        conndev_iface = dbus.Interface(self.get_bus()\
                                       .get_object('org.bluez', 
                                                   '%s/%s' % 
                                                   (self.bt_adapter_path, 
                                                    device), 
                                                   introspect=True), 
                                       self.bt_device_iface)
        conndev_iface.Disconnect()
      except:
        pass
    gobject.idle_add(self.run_commands, False)

  def turn_mode(self, mode):
    gobject.idle_add(self.run_mode_commands, mode)

  def run_commands(self, flag):
    self.get_interface('BlueZAdapter').SetProperty('Powered', flag)
    self.switched()

  def run_mode_commands(self, visible):
    self.get_interface('BlueZAdapter').SetProperty('Discoverable', 
                                                   bool(visible))
    self.switched()
