# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
GSM interface object
'''

import dbus, gobject
from advifswlib.interfaces.Abstract import InterfaceState, AbstractInterface

class GSMInterface(AbstractInterface):

#  radio_access_signal = 'radio_access_technology_change'

  ssc_status = [('offline', 'inactive',
                 'simless', 'tablet_state',
                 'blocked_sim', 'sim_locked'),
                ('activation_failed', 'selection_failed'),
                ('online','sim_ready', 'initialize'),
                ('activation_pending',)]

  #'sim_mode_als2' - what's that...
  #status_on = (3,4,5,9,10,11)
  #status_connected = (0,1,2)

  def pre_init(self):
    self.interfaces = {'Phone': ['com.nokia.phone.net',
                                 '/com/nokia/phone/net',
                                 'Phone.Net',
                                 None,
                                 False],
                       'SSC': ['com.nokia.phone.SSC',
                               '/com/nokia/phone/SSC',
                               'com.nokia.phone.SSC',
                               None,
                               True],
                       'SIM': ['com.nokia.phone.SIM',
                               '/com/nokia/phone/SIM',
                               'Phone.Sim',
                               None,
                               False]}
    self.state = {'name': 'GSM',
                  'dbus': {'on': {'name': 'cellular_system_state_change',
                                  'iface': self.interfaces['Phone'][2],
                                  'path': self.interfaces['Phone'][1],
                                  'args': {}},
                           'connected': {'name': 'modem_state_changed_ind',
                                         'iface': self.interfaces['SSC'][2],
                                         'path': self.interfaces['SSC'][1],
                                         'args': {}},
                           'strength': {'name': 'signal_strength_change',
                                        'iface': self.interfaces['Phone'][2],
                                        'path': self.interfaces['Phone'][1],
                                        'args': {}},
                           'operator': {'name': 'operator_name_change',
                                        'iface': self.interfaces['Phone'][2],
                                        'path': self.interfaces['Phone'][1],
                                        'args': {}},
                          },
                  'images': ('ifsw_statusarea_cell_off',
                             'ifsw_statusarea_cell_signal_0',
                             'ifsw_statusarea_cell_signal_5',
                             'ifsw_statusarea_cell_connecting'),
                  'images_st': ('ifsw_statusarea_cell_signal_0',
                                'ifsw_statusarea_cell_signal_1',
                                'ifsw_statusarea_cell_signal_2',
                                'ifsw_statusarea_cell_signal_3',
                                'ifsw_statusarea_cell_signal_4',
                                'ifsw_statusarea_cell_signal_5'),
                  'text': ['Off', 'On', '<>', 'Connecting'],
                  'show': (True, True, False, True),
                  'banner': (True, True, True, True),
                  'value': InterfaceState.off,
                  'strength': 0,
                  'modes': ('gsm-3g+gsm', 'gsm-2g', 'gsm-3g'),
                  'mode': 0}


  def process_signal_on(self, state, arg1, arg2):
    return self.get_status()

  def process_signal_connected(self, value):
    try:
      value = str(value)
      result = None
      strength = None
      if value in self.ssc_status[InterfaceState.off]:
        result = InterfaceState.off
      elif value in self.ssc_status[InterfaceState.connecting]:
        result = InterfaceState.connecting
      elif value in self.ssc_status[InterfaceState.connected]:
        result = InterfaceState.connected
        if self.get_config_value('show-signal-strength'):
          strength = self.get_strength()
        sp_info = self.get_interface('SIM').get_service_provider_name()
        if sp_info:
          self.process_signal_operator(None, sp_info[0])
      else:
        print 'unknown:', value
        result = InterfaceState.on
      #return 1 + ['activation_pending', 'online'].index(str(value)), 
      return result, self.get_mode(), strength
    except Exception, e:
      print self.get_name(), e
      return None, None, None

  def process_signal_strength(self, arg1, arg2):
      return None, \
             None, \
             self.get_strength_value(arg1) \
             if self.get_config_value('show-signal-strength') \
             else None

  def process_signal_operator(self, arg1, opname, empty=None, mnc=None, mcc=None):
    opname = str(opname)
    if opname:
      #self.state['text'][InterfaceState.connected] = opname
      self.network = opname
    return None, None, None

  def get_status(self):
    value = self.get_interface('SSC').get_modem_state()
    return self.process_signal_connected(value)

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def turn_mode(self, mode, startup):
    gobject.idle_add(self.run_mode_commands, mode)

  def run_commands(self, flag):
    self.get_interface('SSC').set_radio(flag)
    self.switched()

  def run_mode_commands(self, mode):
    self.get_interface('Phone').set_selected_radio_access_technology(dbus.Byte(mode))
    self.switched()

  def get_mode(self):
    return int(self.get_interface('Phone').get_selected_radio_access_technology()[0])

  def get_strength(self):
    arg1, arg2, arg3 = self.get_interface('Phone').get_signal_strength()
    return self.get_strength_value(arg1)

  def get_strength_value(self, value):
    return (value+20)/21 #int(round(min(1.0, float(value)/100.0)*5))
