#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math
import pango

import clock

def get_name():
    return "Display time and alarm"

class AlarmDisplayClock(clock.Clock):
    def __init__(self, drawing_area):
        clock.Clock.__init__(self, drawing_area)

    def draw_clock(self):
# Draw time.
        self.context.set_font_size(20)
        self.context.move_to(2, 16 if self.alarm_enabled else 26)

        h = self.time.hour
        abrv = "AM"
        if self.twelve_hour_mode :
            if h == 0 :
                h = 12
            elif h > 12 :
                h = h % 12
                abrv = "PM"

        text = str(h).zfill(2) + ":" + str(self.time.minute).zfill(2)
        if self.show_seconds :
            text = text + ":" + str(self.time.second).zfill(2)
        
        self.context.text_path(text)

        if self.fill :
            self.context.fill()
        else :
            self.context.stroke()

        if self.twelve_hour_mode :
            self.context.set_font_size(10)


            if self.show_seconds :
                self.context.move_to(self.char_width * 9, 16 if self.alarm_enabled else 26)
            else :
                self.context.move_to(self.char_width * 6, 16 if self.alarm_enabled else 26)
            
            self.context.text_path(abrv)

            if self.fill :
                self.context.fill()
            else :
                self.context.stroke()

# Draw alarm time
        if self.alarm_enabled :
            self.context.set_font_size(20)
            self.context.move_to(2, 35)
            self.context.set_source_rgb(1.0, 0.0, 0.0)

            h = self.alarm_time.hour
            abrv = "AM"
            if self.twelve_hour_mode :
                if h == 0 :
                    h = 12
                elif h > 12 :
                    h = h % 12
                    abrv = "PM"

            text = str(h).zfill(2) + ":" + str(self.alarm_time.minute).zfill(2)
            if self.show_seconds :
                text = text + ":" + str(self.alarm_time.second).zfill(2)
        
            self.context.text_path(text)

            if self.fill :
                self.context.fill()
            else :
                self.context.stroke()

            if self.twelve_hour_mode :
                self.context.set_font_size(10)

                if self.show_seconds :
                    self.context.move_to(self.char_width * 9, 35)
                else :
                    self.context.move_to(self.char_width * 6, 35)
            
                self.context.text_path(abrv)

                if self.fill :
                    self.context.fill()
                else :
                    self.context.stroke()

    def draw_alarm_indicator(self): 
        pass

    def resize_alarm_enabled(self):
        pass

    def resize(self):
        ctx = self.drawing_area.create_pango_context()
        fdesc = pango.FontDescription(self.font_name + " 20")  
        metric = ctx.get_metrics(fdesc)
        self.char_width = int(metric.get_approximate_digit_width() / pango.SCALE * 0.7)

        if self.twelve_hour_mode :
            if self.show_seconds :
                self.drawing_area.set_size_request(self.char_width * 11, 36)
            else:
                self.drawing_area.set_size_request(self.char_width * 9, 36)
        else :
            if self.show_seconds :
                self.drawing_area.set_size_request(self.char_width * 9, 36)
            else:
                self.drawing_area.set_size_request(self.char_width * 6, 36)

