#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

class Clock():
    def __init__(self, drawing_area):
        self.drawing_area = drawing_area

        self.alarm_enabled = False
        self.alarm_time = None

        self.fill = False
        self.show_seconds = True

        self.color_r = 1.0
        self.color_g = 1.0
        self.color_b = 1.0

        self.twelve_hour_mode = False

    def draw(self):
        self.time = datetime.today()
        self.context = self.drawing_area.window.cairo_create()

        self.context.set_source_rgba(1.0, 1.0, 1.0, 0.0)
        self.context.set_operator(cairo.OPERATOR_SOURCE)
        self.context.paint()

        self.context.set_source_rgb(self.color_r, self.color_g, self.color_b)
        self.context.save()
        self.draw_clock()
        self.context.restore()

        if self.alarm_enabled:
            self.draw_alarm_indicator()

    def draw_alarm_indicator(self):
        self.context.set_source_rgb(1.0, 0.0, 0.0)
        self.context.arc(self.drawing_area.get_size_request()[0] - 8, 8, 7, 0, 2 * math.pi)
        self.context.fill()

    def draw_clock(self):
        print "Implement draw_clock."

    def get_alarm_enabled(self):
        return self.alarm_enabled

    def get_alarm_time(self):
        return self.alarm_time

    def get_gdk_color(self):
        return gtk.gdk.Color(int(self.color_r * 65535), int(self.color_g * 65535), int(self.color_b * 65535))

    def get_fill(self):
        return self.fill

    def get_show_seconds(self):
        return self.show_seconds

    def get_twelve_hour_mode(self):
        return self.twelve_hour_mode

    def resize(self):
        print "Implement resize."

    def resize_alarm_enabled(self):
        size = self.drawing_area.get_size_request()
        self.drawing_area.set_size_request(size[0] + 18, size[1])

    def set_alarm_enabled(self, b):
        self.alarm_enabled = b
        if self.alarm_enabled :
            self.resize_alarm_enabled()
        else :
            self.resize()

    def set_alarm_time(self, time):
        self.alarm_time = time

    def set_gdk_color(self, color):
        self.color_r = int(color.red / 65535)
        self.color_g = int(color.green / 65535)
        self.color_b = int(color.blue / 65535)
        
    def set_color(self, r, g, b):
        self.color_r = r
        self.color_g = g
        self.color_b = b

    def set_fill(self, b):
        self.fill = b

    def set_show_seconds(self, b):
        self.show_seconds = b

    def set_twelve_hour_mode(self, b):
        self.twelve_hour_mode = b

