#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "Decimal Clock"

class DecimalClock(clock.Clock):
    def __init__(self, drawing_area):
        clock.Clock.__init__(self, drawing_area)

    def draw_clock(self):
        self.context.set_font_size(45)
        self.context.move_to(2, 35)

        h = self.time.hour
        abrv = "AM"
        if self.twelve_hour_mode :
            if h == 0 :
                h = 12
            elif h > 12 :
                h = h % 12
                abrv = "PM"

        text = str(h).zfill(2) + ":" + str(self.time.minute).zfill(2)
        if self.show_seconds :
            text = text + ":" + str(self.time.second).zfill(2)
        
        self.context.text_path(text)
        if self.fill :
            self.context.fill()
        else :
            self.context.stroke()


        if self.twelve_hour_mode :
            self.context.set_font_size(20)

            if self.show_seconds :
                self.context.move_to(180, 35)
            else :
                self.context.move_to(120, 35)
            
            self.context.text_path(abrv)
            self.context.stroke()

    def resize(self):
        if self.twelve_hour_mode :
            if self.show_seconds :
                self.drawing_area.set_size_request(212, 36)
            else:
                self.drawing_area.set_size_request(152, 36)
        else :
            if self.show_seconds :
                self.drawing_area.set_size_request(178, 36)
            else:
                self.drawing_area.set_size_request(118, 36)

    def resize_alarm_enabled(self):
        if not self.twelve_hour_mode :
            clock.Clock.resize_alarm_enabled(self)

