#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk

class Clock():
    def __init__(self, drawing_area):
        self.drawing_area = drawing_area

        self.show_seconds = True

        self.color_r = 1.0
        self.color_g = 1.0
        self.color_b = 1.0

        self.twelve_hour_mode = False

    def draw(self):
        self.time = datetime.today()
        self.context = self.drawing_area.window.cairo_create()

        self.context.set_source_rgba(1.0, 1.0, 1.0, 0.0)
        self.context.set_operator(cairo.OPERATOR_SOURCE)
        self.context.paint()

        self.context.set_source_rgb(self.color_r, self.color_g, self.color_b)
        self.draw_clock()

    def draw_clock(self):
        print "Implement me..."

    def get_show_seconds(self):
        return self.show_seconds

    def get_twelve_hour_mode(self):
        return self.twelve_hour_mode

    def resize(self):
        print "Implement me..."

    def set_color(self, r, g, b):
        self.color_r = r
        self.color_g = g
        self.color_b = b

    def set_show_seconds(self, b):
        self.show_seconds = b

    def set_twelve_hour_mode(self, b):
        self.twelve_hour_mode = b

