#
# Copyright 2010 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "Analog Clock"

class AnalogClock(clock.Clock):
    def draw_clock(self):
        self.context.arc(18, 18, 17, 0, 2 * math.pi)
        self.context.stroke()

        h = self.time.hour
        if h == 0 :
            h = 12
        elif h > 12 :
            h = h % 12

        m = self.time.minute
        h += m / 60.0

        self.context.save()

        self.context.set_line_width(1.5 * self.context.get_line_width())
        self.context.move_to(18, 18)
        self.context.line_to(18 + 9 * math.cos(h * math.pi / 6 - math.pi / 2), 18 + 9 * math.sin(h * math.pi / 6 - math.pi / 2))
        self.context.stroke()
        self.context.restore()

        self.context.move_to(18, 18)
        self.context.line_to(18 + 14 * math.cos(m * math.pi / 30 - math.pi / 2), 18 + 14 * math.sin(m * math.pi / 30 - math.pi / 2))
        self.context.stroke()

        if self.show_seconds :
            s = self.time.second
            self.context.set_source_rgb(self.color_r * 0.6, self.color_g * 0.6, self.color_b * 0.6)
            self.context.move_to(18, 18)
            self.context.line_to(18 + 17 * math.cos(s * math.pi / 30 - math.pi / 2), 18 + 17 * math.sin(s * math.pi / 30 - math.pi / 2))
            self.context.stroke()

    def resize(self):
        self.drawing_area.set_size_request(36, 36)

