#
# Copyright 2011 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import cairo
from datetime import datetime
import gtk
import math

import clock

def get_name():
    return "GTK Test Clock"

class GtkTestClock(clock.Clock):
    def draw_clock(self):
        self.drawable.draw_arc(self.gc, False, 2, 2, 32, 32, 0, 360 * 64)

        self.img1 = gtk.gdk.pixbuf_new_from_file("/home/user/MyDocs/transparent.gif")
        self.drawable.draw_pixbuf(self.gc, self.img1, 0, 0, 36, 0, -1, -1)

        self.anim = gtk.gdk.PixbufAnimation("/home/user/MyDocs/animated.gif")
        self.image = gtk.Image()
        # self.image.set_from_file("/home/user/MyDocs/animated.gif")
        self.image.set_from_animation(self.anim)
        self.image.show()


    def resize(self):
        self.drawing_area.set_size_request(140, 36)


