/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDBusServer.cpp
 Author      : Joost Kop
 Description : Implements the c++ DBus Server side of the ActionManager interface
 ============================================================================
 */

#include "ActionManagerDBusServer.h"

//The next function is implemented in DBusServer.c!
extern "C" void ActionManagerDBusServer_Init(ActionManagerDaemon* ActionManager);

ActionManagerDBusServer::ActionManagerDBusServer(ActionManagerDaemon* daemon)
{
	pDaemon = daemon;
	ActionManagerDBusServer_Init(pDaemon);
}

gboolean actionmanager_object_save_current_settings(ActionManagerObject* obj, GError** error)
{
	g_assert(obj != NULL);
	//Get the containers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	pDaemon->SaveConfiguration();

	return TRUE;
}

//DBus functions
gboolean actionmanager_object_get_all_trigger_containers(ActionManagerObject* obj, char*** trigContainers_list, GError** error)
{
	char **list;
	g_assert(obj != NULL);
	//Get the containers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	StringList names = pDaemon->GetAllTriggerContainers();
	//create the list
	int size = names.size();
	list = g_new(char *, (size+1));
	for(int i=0; i<size; i++)
	{
		list[i] =  g_strdup (names[i].c_str());
	}
	//add null pointer to the end
	list[size] = NULL;

	*trigContainers_list = list;
	//Who is going to delete the create memory locations????

	return TRUE;
}

gboolean actionmanager_object_get_triggers_from_container(ActionManagerObject* obj, char* container, char*** trigger_list, GError** error)
{
	char **list;
	g_assert(obj != NULL);
	//Get the triggers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	StringList names = pDaemon->GetAllTriggers(container);
	//create the list
	int size = names.size();
	list = g_new(char *, (size+1));
	for(int i=0; i<size; i++)
	{
		list[i] =  g_strdup (names[i].c_str());
	}
	//add null pointer to the end
	list[size] = NULL;

	*trigger_list = list;
	//Who is going to delete the create memory locations????

	return TRUE;
}

gboolean actionmanager_object_get_all_actions(ActionManagerObject* obj, char*** actions_list, GError** error)
{
	char **list;
	g_assert(obj != NULL);
	//Get the triggers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	StringList names = pDaemon->GetAllActions();
	//create the list
	int size = names.size();
	list = g_new(char *, (size+1));
	for(int i=0; i<size; i++)
	{
		list[i] =  g_strdup (names[i].c_str());
	}
	//add null pointer to the end
	list[size] = NULL;

	*actions_list = list;
	//Who is going to delete the create memory locations????

	return TRUE;
}

gboolean actionmanager_object_get_used_actions_from_trigger(ActionManagerObject* obj, char* triggerCointainer, char* trigger, char*** actions_list, GError** error)
{
	char **list;
	g_assert(obj != NULL);
	//Get the triggers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	StringList names = pDaemon->GetUsedActions(triggerCointainer, trigger);
	//create the list
	int size = names.size();
	list = g_new(char *, (size+1));
	for(int i=0; i<size; i++)
	{
		list[i] =  g_strdup (names[i].c_str());
	}
	//add null pointer to the end
	list[size] = NULL;

	*actions_list = list;
	//Who is going to delete the create memory locations????

	return TRUE;
}

gboolean actionmanager_object_set_action(ActionManagerObject* obj, char* triggerCointainer, char* trigger, char* action, gboolean enable, GError** error)
{
	g_assert(obj != NULL);
	//Get the triggers
	ActionManagerDaemon *pDaemon = (ActionManagerDaemon*)obj->pDaemon;
	pDaemon->SetAction(triggerCointainer, trigger, action, enable);
	//delete triggerCointainer, trigger, action???

	return TRUE;
}

