/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Headphone.cpp
 Author      : Joost Kop
 Description :
 ============================================================================
 */
#include "Headphone.h"

#define STATE_FILE "/sys/devices/platform/gpio-switch/headphone/state"
#define STATE_CONNECTED_STR "connected"
#define STATE_DISCONNECTED_STR "disconnected"

#define HEADPHONED_TRIGGER_PLUGIN_NAME "Headphone Plugin"
#define HEADPHONED_TRIGGER_PLUGOUT_NAME "Headphone Pullout"

static gboolean on_file_changed(GIOChannel* source, GIOCondition condition, gpointer data)
{
	Headphone* pHeadphone = (Headphone*)data;
	gchar* result;

	g_io_channel_seek_position(source, 0, G_SEEK_SET, NULL);
	g_io_channel_read_line(source, &result, NULL, NULL, NULL);
	g_strstrip(result);

	if (g_ascii_strcasecmp(result, STATE_CONNECTED_STR) == 0) {
		if(pHeadphone->pPluginTrigger)
			pHeadphone->pPluginTrigger->ExecuteTrigger();
	} else {
		if(pHeadphone->pPlugoutTrigger)
			pHeadphone->pPlugoutTrigger->ExecuteTrigger();
	}

	g_free(result);
	return TRUE;
}

/* Class constructor */
Headphone::Headphone()
{
	name = HEADPHONE_CONTAINER_NAME;
	/* Headphone has the following 2 fixed triggers */
	pPluginTrigger = new Trigger(HEADPHONED_TRIGGER_PLUGIN_NAME);
	pPlugoutTrigger = new Trigger(HEADPHONED_TRIGGER_PLUGOUT_NAME);
	TriggerItems.push_back(pPluginTrigger);
	TriggerItems.push_back(pPlugoutTrigger);
	// Set callback functions
	HeadphoneChannel = g_io_channel_new_file(STATE_FILE, "r", NULL);
	g_io_add_watch(HeadphoneChannel, G_IO_PRI, on_file_changed, this);
}

/* Class destructor */
Headphone::~Headphone()
{
}

void Headphone::SetData(Element *elem)
{
	Node::NodeList list = elem->get_children();
	for(Node::NodeList::iterator iter = list.begin(); iter != list.end(); ++iter)
	{
		Element *cur_node = (Element*)*iter;
		if(cur_node->get_name() == TRIGGER_ELEM_NAME)
		{
			ustring name = cur_node->get_attribute_value("name");
			if(!name.empty())
			{
				if(name == HEADPHONED_TRIGGER_PLUGOUT_NAME)
				{
					pPlugoutTrigger->SetData(cur_node);
				}
				else if(name == HEADPHONED_TRIGGER_PLUGIN_NAME)
				{
					pPluginTrigger->SetData(cur_node);
				}
			}
		}
	}
}

TriggerContainer *Headphone::instance(void)
{
	// Make sure there is only one instance
	static Headphone *singleton = new Headphone();
	return (TriggerContainer*)singleton;
}

