/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Containers.c
 Author      : Joost Kop
 Description : Contains a list with links from containerNames to
               the actual Classes
 ============================================================================
 */

#include "TriggerContainers/Containers.h"

#include "TriggerContainers/Headphone.h"

#define SIZEOF(x) (sizeof(x)/sizeof(x[0]))

struct ContainerLink {
	const char *name;
	TriggerContainer *(*CreateContainer)();
};

ContainerLink AvailableContainerList[] = {
		{HEADPHONE_CONTAINER_NAME, Headphone::instance },
		{ NULL, NULL},
};

TriggerContainer *GetAvailableContainerByName(string name)
{
	TriggerContainer *cont = NULL;
	int i = 0;
	while(AvailableContainerList[i].name != NULL)
	{
		if( name == AvailableContainerList[i].name)
		{
			/* create the container */
			cont = AvailableContainerList[i].CreateContainer();
			/* Exit loop */
			i = SIZEOF(AvailableContainerList) - 2; // min. 2, because of i++
		}
		i++;
	}
	return cont;
}

StringList GetAllAvailableContainers(void)
{
	StringList TriggerContainers;
	// Loop thru the triggerContainers
	int i = 0;
	while(AvailableContainerList[i].name != NULL)
	{
		TriggerContainers.push_back(AvailableContainerList[i].name);
		i++;
	}
	return TriggerContainers;
}
