/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : MediaPlayerPlay.cpp
 Author      : Joost Kop
 Description :
 ============================================================================
 */

#include "MediaPlayerPlay.h"
#include "ActionManagerDaemon.h"
#include "osso_context.h"

#define MEDIAPLAYERPLAY_NAME	"MediaPlayer Play"
#define MEDIAPLAYERPLAY_INFO	"Starts playing the MediaPlayer"

#define MEDIA_PLAYER_SRVC "com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer"
#define MEDIA_PLAYER_PATH "/com/nokia/mafw/renderer/gstrenderer"
#define MEDIA_PLAYER_INTF "com.nokia.mafw.renderer"

/* Class constructor */
MediaPlayerPlay::MediaPlayerPlay()
{
	name = MEDIAPLAYERPLAY_NAME;
}

/* Class destructor */
MediaPlayerPlay::~MediaPlayerPlay()
{
}

Action *MediaPlayerPlay::Factory(void)
{
	return (new MediaPlayerPlay());
}

int MediaPlayerPlay::Execute(void)
{
	osso_context_t *osso_context = GetOssoContext();
	if(osso_context)
	{
		osso_rpc_run(osso_context,
				MEDIA_PLAYER_SRVC,
				MEDIA_PLAYER_PATH,
				MEDIA_PLAYER_INTF,
				"play",
				NULL,
				DBUS_TYPE_INVALID);
		return ACTION_SUCCES;
	}
	else
		return ACTION_FAILD;
}
