/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : MediaPlayerPause.cpp
 Author      : Joost Kop
 Description :
 ============================================================================
 */

#include "MediaPlayerPause.h"
#include "ActionManagerDaemon.h"
#include "osso_context.h"

#define MEDIAPLAYERPAUSE_NAME	"MediaPlayer Pause"
#define MEDIAPLAYERPAUSE_INFO	"Pauses the MediaPlayer"

#define MEDIA_PLAYER_SRVC "com.nokia.mafw.renderer.Mafw-Gst-Renderer-Plugin.gstrenderer"
#define MEDIA_PLAYER_PATH "/com/nokia/mafw/renderer/gstrenderer"
#define MEDIA_PLAYER_INTF "com.nokia.mafw.renderer"

/* Class constructor */
MediaPlayerPause::MediaPlayerPause()
{
	name = MEDIAPLAYERPAUSE_NAME;
}

/* Class destructor */
MediaPlayerPause::~MediaPlayerPause()
{
}

Action *MediaPlayerPause::Factory(void)
{
	return (new MediaPlayerPause());
}

int MediaPlayerPause::Execute(void)
{
	osso_context_t *osso_context = GetOssoContext();
	if(osso_context)
	{
		osso_rpc_run(osso_context,
				MEDIA_PLAYER_SRVC,
				MEDIA_PLAYER_PATH,
				MEDIA_PLAYER_INTF,
				"pause",
				NULL,
				DBUS_TYPE_INVALID);
		return ACTION_SUCCES;
	}
	else
		return ACTION_FAILD;
}
