/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Headphone.h
 Author      : Joost Kop
 Version     : 0.1
 Description : headphone trigger container
 ============================================================================
 */

#ifndef HEADPHONE_H
#define HEADPHONE_H

#include "glib.h"
#include <pthread.h>

#include <TriggerContainer.h>

#define HEADPHONE_CONTAINER_NAME "Headphone"

class Headphone : public TriggerContainer
{
private:
	GIOChannel* HeadphoneChannel;
	pthread_t Thread;
	GMainLoop* MonitorLoop;

public:
	Headphone();
	~Headphone();
	static TriggerContainer *Factory(void);

	Trigger *pPluginTrigger;
	Trigger *pPlugoutTrigger;

	void SetData(Element *elem);

};

#endif /* HEADPHONE_H */
