/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : TriggerContainer.h
 Author      : Joost Kop
 Version     : 0.1
 Description : trigger container
 ============================================================================
 */

#ifndef TRIGGERCONTAINER_H
#define TRIGGERCONTAINER_H

#include <vector>
using namespace std;
#include <libxml++/libxml++.h>
using namespace xmlpp;
#include <glib.h>
using namespace Glib;

#include "Trigger.h"

#define TRIGGERCONTAINER_ELEM_NAME "container"

typedef vector<Trigger*> TriggerList;

class TriggerContainer
{
protected:
	TriggerList TriggerItems;
	string name;

public:
	TriggerContainer();
	~TriggerContainer();
	static TriggerContainer *Factory(void);

	TriggerList GetTriggers(void);

	virtual void SetData(Element *elem);
	virtual void GetData(Element *elem);
};

#endif /* TRIGGERCONTAINER_H */
