/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Trigger.cpp
 Author      : Joost Kop
 Version     : 0.1
 Description :
 ============================================================================
 */

#include "Trigger.h"
#include "Actions/Actions.h"

#define SIZEOF(x) (sizeof(x)/sizeof(x[0]))

/* Class constructor */
Trigger::Trigger(string name)
{
	this->name = name;
}

/* Class destructor */
Trigger::~Trigger()
{
	/* Delete the Actions */
	ActionList::iterator iter = Actions.begin();
	while(iter != Actions.end())
	{
		delete *iter;
		iter++;
	}
}

string Trigger::GetName(void)
{
	return name;
}

void Trigger::AddAction(string action, Element *elem)
{
	int i=0;
	/* Find Action */
	while(AvailableActionList[i].name != NULL)
	{
		if(AvailableActionList[i].name == action)
		{
			Action *act = AvailableActionList[i].CreateAction();
			if(elem)
			{
				act->SetData(elem);
			}
			Actions.push_back(act);
			break;
		}
		i++;
	}
}

ActionList Trigger::GetActions(void)
{
	return Actions;
}

void Trigger::ExecuteTrigger(void)
{
	ActionList::iterator iter = Actions.begin();
	while(iter != Actions.end())
	{
		(*iter)->Execute();
		iter++;
	}
}

void Trigger::SetData(Element *elem)
{
	Node::NodeList list = elem->get_children();
	for(Node::NodeList::iterator iter = list.begin(); iter != list.end(); ++iter)
	{
		Element *cur_node = (Element*)*iter;
		if(cur_node->get_name() == ACTION_ELEM_NAME)
		{
			string action = cur_node->get_attribute_value("name");
			AddAction(action, cur_node);
		}
	}
}

void Trigger::GetData(Element *elem)
{
	/* Save name attribute */
	elem->set_attribute("name", name);
	/* Create childs for all Actions */
	ActionList::iterator iter = Actions.begin();
	while(iter != Actions.end())
	{
		Element *cur_node = elem->add_child(ACTION_ELEM_NAME);
		(*iter)->GetData(cur_node);
		iter++;
	}
}
