/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDaemon.cpp
 Author      : Joost Kop
 Version     : 0.1
 Description :
 ============================================================================
 */
#include <libxml++/libxml++.h>
using namespace xmlpp;

#include <glib.h>
using namespace Glib;

#include "ActionManagerDaemon.h"
#include "TriggerContainers/Containers.h"
#include "osso_context.h"

#define ACTIONMANAGERDAEMON_CONFIG_FILE "/home/user/.actionmanager/actionmanager.xml"
#define ACTIONMANAGERDAEMON_ROOT_NAME "actionmanager"

#define SIZEOF(x) (sizeof(x)/sizeof(x[0]))

/* Class constructor */
ActionManagerDaemon::ActionManagerDaemon()
{
	/* Initialize libosso environment */
	CreateOssoContext();

	/* Create the Actions */
/*	int i = 0;
	while(AvailableActionList[i].name != NULL)
	{
		Action *act = AvailableActionList[i].action;
		act->SetParent(this);
		Actions.push_back(act);
		i++;
	}*/
}

/* Class destructor */
ActionManagerDaemon::~ActionManagerDaemon()
{
	/* Delete the triggerContainers */
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		delete ContainerList[i-1];
	}

	/* Clean the libosso environment */
	CloseOssoContext();
}

TriggerList ActionManagerDaemon::GetAllTriggers(void)
{
	TriggerList Triggers;
	/* Loop thru the triggerContainers */
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		TriggerList ConTriggers = ContainerList[i-1]->GetTriggers();
		for(int j=ConTriggers.size(); j>0 ; j--)
		{
			Triggers.push_back(ConTriggers[j-1]);
		}
	}
	return Triggers;
}

/*ActionList ActionManagerDaemon::GetAllActions(void)
{
	//todo
	return NULL;
}*/

void ActionManagerDaemon::SetAction(const char *triggerName, const char *actionName)
{
	Trigger *trig = NULL;

	/* Find Trigger */
	/* Loop thru the triggerContainers */
	for(int i=ContainerList.size(); i>0 ; i--)
	{
		TriggerList ConTriggers = ContainerList[i-1]->GetTriggers();
		for(int j=ConTriggers.size(); j>0 ; j--)
		{
			if( ConTriggers[j-1]->GetName() == triggerName)
			{
				trig =ConTriggers[j-1];
				//break loops?
			}
		}
	}

	/* Add Action */
	if(trig)
	{
		trig->AddAction(actionName);
	}
}

void ActionManagerDaemon::SaveConfiguration(void)
{
	Document *m_doc;
	try
	{
		m_doc = new Document();
		Element *root_node = m_doc->create_root_node(ACTIONMANAGERDAEMON_ROOT_NAME);
		/* Create childs for all TriggerContainers */
		for(int i=ContainerList.size(); i>0 ; i--)
		{
			Element *cur_node = root_node->add_child(TRIGGERCONTAINER_ELEM_NAME);
			ContainerList[i-1]->GetData(cur_node);
		}
		/* Save the document to the file */
		m_doc->write_to_file_formatted(ACTIONMANAGERDAEMON_CONFIG_FILE, "UTF-8");
	}
	catch(const std::exception& ex)
	{
		g_print("Exception caught: %s", ex.what());
	}
	delete m_doc;
}

void ActionManagerDaemon::ReadConfiguration(void)
{
	try
	{
		DomParser parser(ACTIONMANAGERDAEMON_CONFIG_FILE);

		if (!parser)
		{
			g_print("Failed to parse document\n");
		}
		else
		{
			Element *root_node = NULL;
			root_node = parser.get_document()->get_root_node();
			if(root_node->get_name() == ACTIONMANAGERDAEMON_ROOT_NAME)
			{
				/* get all the containers */
				Node::NodeList list = root_node->get_children();
				for(Node::NodeList::iterator iter = list.begin(); iter != list.end(); ++iter)
				{
					Element *cur_node = (Element*)*iter;
					if(cur_node->get_name() == TRIGGERCONTAINER_ELEM_NAME)
					{
						int i = 0;
						ustring name = cur_node->get_attribute_value("name");
						while(AvailableContainerList[i].name != NULL)
						{
							if( name == AvailableContainerList[i].name)
							{
								/* create and add the container */
								TriggerContainer *cont = AvailableContainerList[i].CreateContainer();
								cont->SetData(cur_node);
								ContainerList.push_back(cont);
								/* Exit loop */
								i = SIZEOF(AvailableContainerList) - 2; // min. 2, because of i++
							}
							i++;
						}
					}
				}
			}
		}
	}
	catch(const std::exception& ex)
	{
		g_print("Exception caught: %s", ex.what());
	}

}
