/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDBusClient.c
 Author      : Joost Kop
 Description : Implements the GLib DBus Client side of the interface
 ============================================================================
 */

#include <glib.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h> /* exit, EXIT_FAILURE */
#include <string.h> /* strcmp */

#include "ActionManagerDBusClient.h"

#include "dbus-common.h"
/* Pull in the client stubs that were generated with
   dbus-binding-tool */
#include "ActionManager-client-dbus.h"

#define PROGNAME "ActionManager"

static DBusGProxy* remoteValue;
/**
 * Print out an error message and optionally quit (if fatal is TRUE)
 */
static void handleError(const char* msg, const char* reason,
                                         gboolean fatal) {
  g_printerr(PROGNAME ": ERROR: %s (%s)\n", msg, reason);
  if (fatal) {
    exit(EXIT_FAILURE);
  }
}

void ActionManagerDBusClient_Init(void)
{
	  /* The D-Bus connection object. Provided by GLib/D-Bus wrappers. */
	  DBusGConnection* bus;
	  GError* error = NULL;

	  /* Initialize the GType/GObject system. */
	  g_type_init();

	  g_print(PROGNAME ":main Connecting to Session D-Bus.\n");
	  bus = dbus_g_bus_get(DBUS_BUS_SESSION, &error);
	  if (error != NULL) {
	    handleError("Couldn not connect to the Session bus", error->message,
	                TRUE);
	    /* Normally you would have to also g_error_free() the error object
	       but since the program will terminate within handleError,
	       it is not necessary here. */
	  }

	  g_print(PROGNAME ":main Creating a GLib proxy object for Value.\n");

	  /* Create the proxy object that we will be using to access the object
	     on the server. If you would use dbus_g_proxy_for_name_owner(),
	     you would be also notified when the server that implements the
	     object is removed (or rather, the interface is removed). Since
	     we don not care who actually implements the interface, we will use the
	     more common function. See the API documentation at
	     http://maemo.org/api_refs/4.0/dbus/ for more details. */
	  remoteValue =
	    dbus_g_proxy_new_for_name(bus,
	    		ACTIONMANAGER_SERVICE_NAME, /* name */
	    		ACTIONMANAGER_SERVICE_OBJECT_PATH, /* obj path */
	    		ACTIONMANAGER_SERVICE_INTERFACE /* interface */);
	  if (remoteValue == NULL) {
	    handleError("Couldn not create the proxy object",
	                "Unknown(dbus_g_proxy_new_for_name)", TRUE);
	  }
}

gboolean ActionManager_save_current_settings(void)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_save_current_settings(remoteValue, &error);
	if (error != NULL)
	{
		handleError("Failed to org_maemo_ActionManager_save_current_settings", error->message, FALSE);
	}
	return succes;
}

gboolean ActionManager_get_all_trigger_containers(char ***container_list)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_get_all_trigger_containers(remoteValue, container_list, &error);
	if (error != NULL)
	{
		handleError("Failed to ActionManager_get_all_trigger_containers", error->message, FALSE);
	}
	return succes;
}

gboolean ActionManager_get_triggers_from_container(char *container, char ***trigger_list)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_get_triggers_from_container(remoteValue, container, trigger_list, &error);
	if (error != NULL)
	{
		succes = FALSE;
		handleError("Failed to ActionManager_get_triggers_from_container", error->message, FALSE);
	}
	return succes;
}

gboolean ActionManager_get_all_actions(char ***actions_list)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_get_all_actions(remoteValue, actions_list, &error);
	if (error != NULL)
	{
		handleError("Failed to ActionManager_get_all_actions", error->message, FALSE);
	}
	return succes;
}

gboolean ActionManager_get_used_actions_from_trigger(char *triggerCointainer, char *trigger, char ***action_list)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_get_used_actions_from_trigger(remoteValue, triggerCointainer, trigger, action_list, &error);
	if (error != NULL)
	{
		handleError("Failed to ActionManager_get_used_actions_from_trigger", error->message, FALSE);
	}
	return succes;
}

gboolean ActionManager_set_action(char *triggerCointainer, char *trigger, char *action, gboolean enable)
{
	GError* error = NULL;
	gboolean succes = TRUE;
	succes = org_maemo_ActionManager_set_action(remoteValue, triggerCointainer, trigger, action, enable, &error);
	if (error != NULL)
	{
		handleError("Failed to ActionManager_set_action", error->message, FALSE);
	}
	return succes;
}
