#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include "lookup.h"
#include "global_objects.hpp"
#include <QMessageBox>
#include <QTextStream>


double mdSatFat = 0;
double mdCals = 0;
QString SelectedLine1;

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->btnStore->setVisible(false);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}


void MainWindow::on_pushButton_1_clicked()
{
   ui->lineEdit->insert("1");
}

void MainWindow::on_pushButton_2_clicked()
{
    ui->lineEdit->insert("2");
}

void MainWindow::on_pushButton_3_clicked()
{
    ui->lineEdit->insert("3");
}

void MainWindow::on_pushButton_4_clicked()
{
    ui->lineEdit->insert("4");
}

void MainWindow::on_pushButton_5_clicked()
{
    ui->lineEdit->insert("5");
}

void MainWindow::on_pushButton_6_clicked()
{
    ui->lineEdit->insert("6");
}

void MainWindow::on_pushButton_7_clicked()
{
    ui->lineEdit->insert("7");
}

void MainWindow::on_pushButton_8_clicked()
{
    ui->lineEdit->insert("8");
}

void MainWindow::on_pushButton_9_clicked()
{
    ui->lineEdit->insert("9");
}

void MainWindow::on_pushButton_0_clicked()
{
    ui->lineEdit->insert("0");
}

void MainWindow::on_pushButton_Dot_clicked()
{
    ui->lineEdit->insert(".");
}

void MainWindow::on_pushButton_Del_clicked()
{
    ui->lineEdit->backspace();
}

void MainWindow::on_pushButton_Clear_clicked()
{
    ui->lineEdit->clear();
    ui->lineEdit->setText("");
    ui->label_Main->setText("Calories:");
    ui->pushButton_Go->setText("Next");
    ui->pushButton_Go->setVisible(true);
    ui->btnStore->setVisible(false);
    ui->label_Answer->setText("");
}




double normaliseFat(int iInSwitchFat)
{
    if (iInSwitchFat < 50)
    {
        return iInSwitchFat;
    }

    // Multiply by 10 as we have .5's
    switch (iInSwitchFat)
    {
        case 55: return 60;
        case 65: return 70;
        case 75: return 80;
        case 85: return 90;
        case 105:
        case 110:
        case 115: return 120;
        case 125:
        case 130:
        case 135: return 140;
        case 145:
        case 150:
        case 155: return 160;
        case 165:
        case 170:
        case 175: return 180;
        case 185:
        case 190:
        case 195: return 200;
        default: return iInSwitchFat;
    }

}

double getPointsFor0(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+0.5   ; break;
            case    5:   fReturn=fReturn+0.5   ; break;
            case    10:  fReturn=fReturn+0.5   ; break;
            case    15:  fReturn=fReturn+0.5   ; break;
            case    20:  fReturn=fReturn+1.0   ; break;
            case    25:  fReturn=fReturn+0     ; break;
            case    30:  fReturn=fReturn+0     ; break;
            case    35:  fReturn=fReturn+0     ; break;
            case    40:  fReturn=fReturn+0     ; break;
            case    45:  fReturn=fReturn+0     ; break;
            case    50:  fReturn=fReturn+0     ; break;
            case    55:  fReturn=fReturn+0     ; break;
            case    60:  fReturn=fReturn+0     ; break;
            case    70:  fReturn=fReturn+0     ; break;
            case    80:  fReturn=fReturn+0     ; break;
            case    90:  fReturn=fReturn+0     ; break;
            case    100: fReturn=fReturn+0     ; break;
            case    120: fReturn=fReturn+0     ; break;
            case    140: fReturn=fReturn+0     ; break;
            case    160: fReturn=fReturn+0     ; break;
            case    180: fReturn=fReturn+0     ; break;
            case    200: fReturn=fReturn+0     ; break;
        }
    }

    return fReturn;

}

double getPointsFor20(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+0.5   ; break;
            case    5:   fReturn=fReturn+0.5   ; break;
            case    10:  fReturn=fReturn+0.5   ; break;
            case    15:  fReturn=fReturn+0.5   ; break;
            case    20:  fReturn=fReturn+1.0   ; break;
            case    25:  fReturn=fReturn+1.0     ; break;
            case    30:  fReturn=fReturn+1.0     ; break;
            case    35:  fReturn=fReturn+1.0     ; break;
            case    40:  fReturn=fReturn+1.5   ; break;
            case    45:  fReturn=fReturn+1.5   ; break;
            case    50:  fReturn=fReturn+1.5   ; break;
            case    55:  fReturn=fReturn+1.5   ; break;
            case    60:  fReturn=fReturn+2.0   ; break;
            case    70:  fReturn=fReturn+2.0   ; break;
            case    80:  fReturn=fReturn+2.0   ; break;
            case    90:  fReturn=fReturn+2.0   ; break;
            case    100: fReturn=fReturn+2.5   ; break;
            case    120: fReturn=fReturn+2.5   ; break;
            case    140: fReturn=fReturn+2.5   ; break;
            case    160: fReturn=fReturn+2.5   ; break;
            case    180: fReturn=fReturn+3.0   ; break;
            case    200: fReturn=fReturn+3.0   ; break;
        }
    }

    return fReturn;

}


double getPointsFor40(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+0.5   ; break;
            case    5:   fReturn=fReturn+0.5   ; break;
            case    10:  fReturn=fReturn+1.0   ; break;
            case    15:  fReturn=fReturn+1.0   ; break;
            case    20:  fReturn=fReturn+1.0   ; break;
            case    25:  fReturn=fReturn+1.0   ; break;
            case    30:  fReturn=fReturn+1.5   ; break;
            case    35:  fReturn=fReturn+1.5   ; break;
            case    40:  fReturn=fReturn+1.5   ; break;
            case    45:  fReturn=fReturn+1.5   ; break;
            case    50:  fReturn=fReturn+2.0   ; break;
            case    55:  fReturn=fReturn+2.0   ; break;
            case    60:  fReturn=fReturn+2.0   ; break;
            case    70:  fReturn=fReturn+2.0   ; break;
            case    80:  fReturn=fReturn+2.5   ; break;
            case    90:  fReturn=fReturn+2.5   ; break;
            case    100: fReturn=fReturn+2.5   ; break;
            case    120: fReturn=fReturn+2.5   ; break;
            case    140: fReturn=fReturn+3.0   ; break;
            case    160: fReturn=fReturn+3.0   ; break;
            case    180: fReturn=fReturn+3.0   ; break;
            case    200: fReturn=fReturn+3.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor60(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+1.0   ; break;
            case    5:   fReturn=fReturn+1.0   ; break;
            case    10:  fReturn=fReturn+1.0   ; break;
            case    15:  fReturn=fReturn+1.0   ; break;
            case    20:  fReturn=fReturn+1.5   ; break;
            case    25:  fReturn=fReturn+1.5   ; break;
            case    30:  fReturn=fReturn+1.5   ; break;
            case    35:  fReturn=fReturn+1.5   ; break;
            case    40:  fReturn=fReturn+2.0   ; break;
            case    45:  fReturn=fReturn+2.0   ; break;
            case    50:  fReturn=fReturn+2.0   ; break;
            case    60:  fReturn=fReturn+2.0   ; break;
            case    70:  fReturn=fReturn+2.5   ; break;
            case    80:  fReturn=fReturn+2.5   ; break;
            case    90:  fReturn=fReturn+2.5   ; break;
            case    100: fReturn=fReturn+2.5   ; break;
            case    120: fReturn=fReturn+3.0   ; break;
            case    140: fReturn=fReturn+3.0   ; break;
            case    160: fReturn=fReturn+3.0   ; break;
            case    180: fReturn=fReturn+3.0   ; break;
            case    200: fReturn=fReturn+3.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor80(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+1.0   ; break;
            case    5:   fReturn=fReturn+1.5   ; break;
            case    10:  fReturn=fReturn+1.5   ; break;
            case    15:  fReturn=fReturn+1.5   ; break;
            case    20:  fReturn=fReturn+1.5   ; break;
            case    25:  fReturn=fReturn+2.0   ; break;
            case    30:  fReturn=fReturn+2.0   ; break;
            case    35:  fReturn=fReturn+2.0   ; break;
            case    40:  fReturn=fReturn+2.0   ; break;
            case    45:  fReturn=fReturn+2.5   ; break;
            case    50:  fReturn=fReturn+2.5   ; break;
            case    60:  fReturn=fReturn+2.5   ; break;
            case    70:  fReturn=fReturn+3.0   ; break;
            case    80:  fReturn=fReturn+3.0   ; break;
            case    90:  fReturn=fReturn+3.0   ; break;
            case    100: fReturn=fReturn+3.0   ; break;
            case    120: fReturn=fReturn+3.5   ; break;
            case    140: fReturn=fReturn+3.5   ; break;
            case    160: fReturn=fReturn+3.5   ; break;
            case    180: fReturn=fReturn+3.5   ; break;
            case    200: fReturn=fReturn+4.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor100(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+1.5   ; break;
            case    5:   fReturn=fReturn+1.5   ; break;
            case    10:  fReturn=fReturn+1.5   ; break;
            case    15:  fReturn=fReturn+1.5   ; break;
            case    20:  fReturn=fReturn+2.0   ; break;
            case    25:  fReturn=fReturn+2.0   ; break;
            case    30:  fReturn=fReturn+2.0   ; break;
            case    35:  fReturn=fReturn+2.5   ; break;
            case    40:  fReturn=fReturn+2.5   ; break;
            case    45:  fReturn=fReturn+2.5   ; break;
            case    50:  fReturn=fReturn+2.5   ; break;
            case    60:  fReturn=fReturn+3.0   ; break;
            case    70:  fReturn=fReturn+3.0   ; break;
            case    80:  fReturn=fReturn+3.5   ; break;
            case    90:  fReturn=fReturn+3.5   ; break;
            case    100: fReturn=fReturn+4.0   ; break;
            case    120: fReturn=fReturn+4.0   ; break;
            case    140: fReturn=fReturn+4.0   ; break;
            case    160: fReturn=fReturn+4.0   ; break;
            case    180: fReturn=fReturn+4.0   ; break;
            case    200: fReturn=fReturn+4.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor120(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+1.5   ; break;
            case    5:   fReturn=fReturn+2.0   ; break;
            case    10:  fReturn=fReturn+2.0   ; break;
            case    15:  fReturn=fReturn+2.0   ; break;
            case    20:  fReturn=fReturn+2.0   ; break;
            case    25:  fReturn=fReturn+2.5   ; break;
            case    30:  fReturn=fReturn+2.5   ; break;
            case    35:  fReturn=fReturn+2.5   ; break;
            case    40:  fReturn=fReturn+2.5   ; break;
            case    45:  fReturn=fReturn+3.0   ; break;
            case    50:  fReturn=fReturn+3.0   ; break;
            case    60:  fReturn=fReturn+3.0   ; break;
            case    70:  fReturn=fReturn+3.5   ; break;
            case    80:  fReturn=fReturn+3.5   ; break;
            case    90:  fReturn=fReturn+4.0   ; break;
            case    100: fReturn=fReturn+4.0   ; break;
            case    120: fReturn=fReturn+4.5   ; break;
            case    140: fReturn=fReturn+4.5   ; break;
            case    160: fReturn=fReturn+4.5   ; break;
            case    180: fReturn=fReturn+4.5   ; break;
            case    200: fReturn=fReturn+5.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor140(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+2.0   ; break;
            case    5:   fReturn=fReturn+2.0   ; break;
            case    10:  fReturn=fReturn+2.5   ; break;
            case    15:  fReturn=fReturn+2.5   ; break;
            case    20:  fReturn=fReturn+2.5   ; break;
            case    25:  fReturn=fReturn+2.5   ; break;
            case    30:  fReturn=fReturn+3.0   ; break;
            case    35:  fReturn=fReturn+3.0   ; break;
            case    40:  fReturn=fReturn+3.0   ; break;
            case    45:  fReturn=fReturn+3.0   ; break;
            case    50:  fReturn=fReturn+3.5   ; break;
            case    60:  fReturn=fReturn+3.5   ; break;
            case    70:  fReturn=fReturn+4.0   ; break;
            case    80:  fReturn=fReturn+4.0   ; break;
            case    90:  fReturn=fReturn+4.5   ; break;
            case    100: fReturn=fReturn+4.5   ; break;
            case    120: fReturn=fReturn+5.0   ; break;
            case    140: fReturn=fReturn+5.5   ; break;
            case    160: fReturn=fReturn+5.5   ; break;
            case    180: fReturn=fReturn+5.5   ; break;
            case    200: fReturn=fReturn+6.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor160(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+2.5   ; break;
            case    5:   fReturn=fReturn+2.5   ; break;
            case    10:  fReturn=fReturn+2.5   ; break;
            case    15:  fReturn=fReturn+2.5   ; break;
            case    20:  fReturn=fReturn+3.0   ; break;
            case    25:  fReturn=fReturn+3.0   ; break;
            case    30:  fReturn=fReturn+3.0   ; break;
            case    35:  fReturn=fReturn+3.0   ; break;
            case    40:  fReturn=fReturn+3.5   ; break;
            case    45:  fReturn=fReturn+3.5   ; break;
            case    50:  fReturn=fReturn+3.5   ; break;
            case    60:  fReturn=fReturn+4.0   ; break;
            case    70:  fReturn=fReturn+4.0   ; break;
            case    80:  fReturn=fReturn+4.5   ; break;
            case    90:  fReturn=fReturn+4.5   ; break;
            case    100: fReturn=fReturn+5.0   ; break;
            case    120: fReturn=fReturn+5.5   ; break;
            case    140: fReturn=fReturn+6.0   ; break;
            case    160: fReturn=fReturn+6.5   ; break;
            case    180: fReturn=fReturn+6.5   ; break;
            case    200: fReturn=fReturn+7.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor180(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+2.5   ; break;
            case    5:   fReturn=fReturn+2.5   ; break;
            case    10:  fReturn=fReturn+3.0   ; break;
            case    15:  fReturn=fReturn+3.0   ; break;
            case    20:  fReturn=fReturn+3.0   ; break;
            case    25:  fReturn=fReturn+3.0   ; break;
            case    30:  fReturn=fReturn+3.5   ; break;
            case    35:  fReturn=fReturn+3.5   ; break;
            case    40:  fReturn=fReturn+3.5   ; break;
            case    45:  fReturn=fReturn+3.5   ; break;
            case    50:  fReturn=fReturn+4.0   ; break;
            case    60:  fReturn=fReturn+4.0   ; break;
            case    70:  fReturn=fReturn+4.5   ; break;
            case    80:  fReturn=fReturn+4.5   ; break;
            case    90:  fReturn=fReturn+5.0   ; break;
            case    100: fReturn=fReturn+5.0   ; break;
            case    120: fReturn=fReturn+5.5   ; break;
            case    140: fReturn=fReturn+6.0   ; break;
            case    160: fReturn=fReturn+6.5   ; break;
            case    180: fReturn=fReturn+7.0   ; break;
            case    200: fReturn=fReturn+7.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor200(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+3.0   ; break;
            case    5:   fReturn=fReturn+3.0   ; break;
            case    10:  fReturn=fReturn+3.0   ; break;
            case    15:  fReturn=fReturn+3.0   ; break;
            case    20:  fReturn=fReturn+3.5   ; break;
            case    25:  fReturn=fReturn+3.5   ; break;
            case    30:  fReturn=fReturn+3.5   ; break;
            case    35:  fReturn=fReturn+3.5   ; break;
            case    40:  fReturn=fReturn+4.0   ; break;
            case    45:  fReturn=fReturn+4.0   ; break;
            case    50:  fReturn=fReturn+4.0   ; break;
            case    60:  fReturn=fReturn+4.5   ; break;
            case    70:  fReturn=fReturn+4.5   ; break;
            case    80:  fReturn=fReturn+5.0   ; break;
            case    90:  fReturn=fReturn+5.0   ; break;
            case    100: fReturn=fReturn+5.5   ; break;
            case    120: fReturn=fReturn+6.0   ; break;
            case    140: fReturn=fReturn+6.5   ; break;
            case    160: fReturn=fReturn+7.0   ; break;
            case    180: fReturn=fReturn+7.5   ; break;
            case    200: fReturn=fReturn+8.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor220(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+3.0   ; break;
            case    5:   fReturn=fReturn+3.5   ; break;
            case    10:  fReturn=fReturn+3.5   ; break;
            case    15:  fReturn=fReturn+3.5   ; break;
            case    20:  fReturn=fReturn+3.5   ; break;
            case    25:  fReturn=fReturn+4.0   ; break;
            case    30:  fReturn=fReturn+4.0   ; break;
            case    35:  fReturn=fReturn+4.0   ; break;
            case    40:  fReturn=fReturn+4.0   ; break;
            case    45:  fReturn=fReturn+4.5   ; break;
            case    50:  fReturn=fReturn+4.5   ; break;
            case    60:  fReturn=fReturn+4.5   ; break;
            case    70:  fReturn=fReturn+5.0   ; break;
            case    80:  fReturn=fReturn+5.0   ; break;
            case    90:  fReturn=fReturn+5.5   ; break;
            case    100: fReturn=fReturn+5.5   ; break;
            case    120: fReturn=fReturn+6.0   ; break;
            case    140: fReturn=fReturn+6.5   ; break;
            case    160: fReturn=fReturn+7.0   ; break;
            case    180: fReturn=fReturn+7.5   ; break;
            case    200: fReturn=fReturn+8.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor240(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+3.5   ; break;
            case    5:   fReturn=fReturn+3.5   ; break;
            case    10:  fReturn=fReturn+3.5   ; break;
            case    15:  fReturn=fReturn+4.0   ; break;
            case    20:  fReturn=fReturn+4.0   ; break;
            case    25:  fReturn=fReturn+4.0   ; break;
            case    30:  fReturn=fReturn+4.0   ; break;
            case    35:  fReturn=fReturn+4.5   ; break;
            case    40:  fReturn=fReturn+4.5   ; break;
            case    45:  fReturn=fReturn+4.5   ; break;
            case    50:  fReturn=fReturn+4.5   ; break;
            case    60:  fReturn=fReturn+5.0   ; break;
            case    70:  fReturn=fReturn+5.0   ; break;
            case    80:  fReturn=fReturn+5.5   ; break;
            case    90:  fReturn=fReturn+5.5   ; break;
            case    100: fReturn=fReturn+6.0   ; break;
            case    120: fReturn=fReturn+6.5   ; break;
            case    140: fReturn=fReturn+7.0   ; break;
            case    160: fReturn=fReturn+7.5   ; break;
            case    180: fReturn=fReturn+8.0   ; break;
            case    200: fReturn=fReturn+8.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor260(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+3.5   ; break;
            case    5:   fReturn=fReturn+4.0   ; break;
            case    10:  fReturn=fReturn+4.0   ; break;
            case    15:  fReturn=fReturn+4.0   ; break;
            case    20:  fReturn=fReturn+4.0   ; break;
            case    25:  fReturn=fReturn+4.5   ; break;
            case    30:  fReturn=fReturn+4.5   ; break;
            case    35:  fReturn=fReturn+4.5   ; break;
            case    40:  fReturn=fReturn+4.5   ; break;
            case    45:  fReturn=fReturn+5.0   ; break;
            case    50:  fReturn=fReturn+5.0   ; break;
            case    60:  fReturn=fReturn+5.0   ; break;
            case    70:  fReturn=fReturn+5.5   ; break;
            case    80:  fReturn=fReturn+5.5   ; break;
            case    90:  fReturn=fReturn+6.0   ; break;
            case    100: fReturn=fReturn+6.0   ; break;
            case    120: fReturn=fReturn+6.5   ; break;
            case    140: fReturn=fReturn+7.0   ; break;
            case    160: fReturn=fReturn+7.5   ; break;
            case    180: fReturn=fReturn+8.0   ; break;
            case    200: fReturn=fReturn+8.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor280(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+4.0   ; break;
            case    5:   fReturn=fReturn+4.0   ; break;
            case    10:  fReturn=fReturn+4.5   ; break;
            case    15:  fReturn=fReturn+4.5   ; break;
            case    20:  fReturn=fReturn+4.5   ; break;
            case    25:  fReturn=fReturn+4.5   ; break;
            case    30:  fReturn=fReturn+5.0   ; break;
            case    35:  fReturn=fReturn+5.0   ; break;
            case    40:  fReturn=fReturn+5.0   ; break;
            case    45:  fReturn=fReturn+5.0   ; break;
            case    50:  fReturn=fReturn+5.5   ; break;
            case    60:  fReturn=fReturn+5.5   ; break;
            case    70:  fReturn=fReturn+6.0   ; break;
            case    80:  fReturn=fReturn+6.0   ; break;
            case    90:  fReturn=fReturn+6.5   ; break;
            case    100: fReturn=fReturn+6.5   ; break;
            case    120: fReturn=fReturn+7.0   ; break;
            case    140: fReturn=fReturn+7.5   ; break;
            case    160: fReturn=fReturn+8.0   ; break;
            case    180: fReturn=fReturn+8.5   ; break;
            case    200: fReturn=fReturn+9.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor300(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+4.5   ; break;
            case    5:   fReturn=fReturn+4.5   ; break;
            case    10:  fReturn=fReturn+4.5   ; break;
            case    15:  fReturn=fReturn+4.5   ; break;
            case    20:  fReturn=fReturn+5.0   ; break;
            case    25:  fReturn=fReturn+5.0   ; break;
            case    30:  fReturn=fReturn+5.0   ; break;
            case    35:  fReturn=fReturn+5.0   ; break;
            case    40:  fReturn=fReturn+5.5   ; break;
            case    45:  fReturn=fReturn+5.5   ; break;
            case    50:  fReturn=fReturn+5.5   ; break;
            case    60:  fReturn=fReturn+6.0   ; break;
            case    70:  fReturn=fReturn+6.0   ; break;
            case    80:  fReturn=fReturn+6.5   ; break;
            case    90:  fReturn=fReturn+6.5   ; break;
            case    100: fReturn=fReturn+7.0   ; break;
            case    120: fReturn=fReturn+7.5   ; break;
            case    140: fReturn=fReturn+8.0   ; break;
            case    160: fReturn=fReturn+8.5   ; break;
            case    180: fReturn=fReturn+8.5   ; break;
            case    200: fReturn=fReturn+9.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor320(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+4.5   ; break;
            case    5:   fReturn=fReturn+4.5   ; break;
            case    10:  fReturn=fReturn+5.0   ; break;
            case    15:  fReturn=fReturn+5.0   ; break;
            case    20:  fReturn=fReturn+5.0   ; break;
            case    25:  fReturn=fReturn+5.0   ; break;
            case    30:  fReturn=fReturn+5.5   ; break;
            case    35:  fReturn=fReturn+5.5   ; break;
            case    40:  fReturn=fReturn+5.5   ; break;
            case    45:  fReturn=fReturn+5.5   ; break;
            case    50:  fReturn=fReturn+6.0   ; break;
            case    60:  fReturn=fReturn+6.0   ; break;
            case    70:  fReturn=fReturn+6.5   ; break;
            case    80:  fReturn=fReturn+6.5   ; break;
            case    90:  fReturn=fReturn+7.0   ; break;
            case    100: fReturn=fReturn+7.0   ; break;
            case    120: fReturn=fReturn+7.5   ; break;
            case    140: fReturn=fReturn+8.0   ; break;
            case    160: fReturn=fReturn+8.5   ; break;
            case    180: fReturn=fReturn+9.0   ; break;
            case    200: fReturn=fReturn+9.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor340(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+5.0   ; break;
            case    5:   fReturn=fReturn+5.0   ; break;
            case    10:  fReturn=fReturn+5.0   ; break;
            case    15:  fReturn=fReturn+5.0   ; break;
            case    20:  fReturn=fReturn+5.5   ; break;
            case    25:  fReturn=fReturn+5.5   ; break;
            case    30:  fReturn=fReturn+5.5   ; break;
            case    35:  fReturn=fReturn+5.5   ; break;
            case    40:  fReturn=fReturn+6.0   ; break;
            case    45:  fReturn=fReturn+6.0   ; break;
            case    50:  fReturn=fReturn+6.0   ; break;
            case    60:  fReturn=fReturn+6.5   ; break;
            case    70:  fReturn=fReturn+6.5   ; break;
            case    80:  fReturn=fReturn+7.0   ; break;
            case    90:  fReturn=fReturn+7.0   ; break;
            case    100: fReturn=fReturn+7.5   ; break;
            case    120: fReturn=fReturn+8.0   ; break;
            case    140: fReturn=fReturn+8.5   ; break;
            case    160: fReturn=fReturn+9.0   ; break;
            case    180: fReturn=fReturn+9.5   ; break;
            case    200: fReturn=fReturn+10.0   ; break;
        }
    }

    return fReturn;

}

double getPointsFor360(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+5.0   ; break;
            case    5:   fReturn=fReturn+5.5   ; break;
            case    10:  fReturn=fReturn+5.5   ; break;
            case    15:  fReturn=fReturn+5.5   ; break;
            case    20:  fReturn=fReturn+5.5   ; break;
            case    25:  fReturn=fReturn+6.0   ; break;
            case    30:  fReturn=fReturn+6.0   ; break;
            case    35:  fReturn=fReturn+6.0   ; break;
            case    40:  fReturn=fReturn+6.0   ; break;
            case    45:  fReturn=fReturn+6.5   ; break;
            case    50:  fReturn=fReturn+6.5   ; break;
            case    60:  fReturn=fReturn+6.5   ; break;
            case    70:  fReturn=fReturn+7.0   ; break;
            case    80:  fReturn=fReturn+7.0   ; break;
            case    90:  fReturn=fReturn+7.5   ; break;
            case    100: fReturn=fReturn+7.5   ; break;
            case    120: fReturn=fReturn+8.0   ; break;
            case    140: fReturn=fReturn+8.5   ; break;
            case    160: fReturn=fReturn+9.0   ; break;
            case    180: fReturn=fReturn+9.5   ; break;
            case    200: fReturn=fReturn+10   ; break;
        }
    }

    return fReturn;

}

double getPointsFor380(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+5.5   ; break;
            case    5:   fReturn=fReturn+5.5   ; break;
            case    10:  fReturn=fReturn+5.5   ; break;
            case    15:  fReturn=fReturn+6.0   ; break;
            case    20:  fReturn=fReturn+6.0   ; break;
            case    25:  fReturn=fReturn+6.0   ; break;
            case    30:  fReturn=fReturn+6.0   ; break;
            case    35:  fReturn=fReturn+6.5   ; break;
            case    40:  fReturn=fReturn+6.5   ; break;
            case    45:  fReturn=fReturn+6.5   ; break;
            case    50:  fReturn=fReturn+6.5   ; break;
            case    60:  fReturn=fReturn+7.0   ; break;
            case    70:  fReturn=fReturn+7.0   ; break;
            case    80:  fReturn=fReturn+7.5   ; break;
            case    90:  fReturn=fReturn+7.5   ; break;
            case    100: fReturn=fReturn+8.0   ; break;
            case    120: fReturn=fReturn+8.5   ; break;
            case    140: fReturn=fReturn+9.0   ; break;
            case    160: fReturn=fReturn+9.5   ; break;
            case    180: fReturn=fReturn+10   ; break;
            case    200: fReturn=fReturn+10.5   ; break;
        }
    }

    return fReturn;

}

double getPointsFor400(double lInFat)
{
    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end

    // Initialise fReturn
    fReturn=0;

    while (lInFat>=0)
    {
        if (lInFat>200)
        {
            iSwitchFat=200;
            lInFat=lInFat-200;
        }
        else
        {
            iSwitchFat=(int) lInFat;
            lInFat=-1;
        }

        iSwitchFat = normaliseFat(iSwitchFat);

        switch (iSwitchFat)
        {
            case    0:   fReturn=fReturn+5.5   ; break;
            case    5:   fReturn=fReturn+6.0   ; break;
            case    10:  fReturn=fReturn+6.0   ; break;
            case    15:  fReturn=fReturn+6.0   ; break;
            case    20:  fReturn=fReturn+6.0   ; break;
            case    25:  fReturn=fReturn+6.5   ; break;
            case    30:  fReturn=fReturn+6.5   ; break;
            case    35:  fReturn=fReturn+6.5   ; break;
            case    40:  fReturn=fReturn+6.5   ; break;
            case    45:  fReturn=fReturn+7.0   ; break;
            case    50:  fReturn=fReturn+7.0   ; break;
            case    60:  fReturn=fReturn+7.0   ; break;
            case    70:  fReturn=fReturn+7.5   ; break;
            case    80:  fReturn=fReturn+7.5   ; break;
            case    90:  fReturn=fReturn+8.0   ; break;
            case    100: fReturn=fReturn+8.0   ; break;
            case    120: fReturn=fReturn+8.5   ; break;
            case    140: fReturn=fReturn+9.0   ; break;
            case    160: fReturn=fReturn+9.5   ; break;
            case    180: fReturn=fReturn+10   ; break;
            case    200: fReturn=fReturn+10.5   ; break;
        }
    }

    return fReturn;

}

double MainWindow::getPoints(int iCals, int iFat)
{
    QString sKey = "config/use_calc_file";
    QString line;

    line = mSelFood.value(sKey).toString();
    if (line!="yes")
    {
        return 0;
    }

    sKey = "config/calcLoc" ;
    QString files = mSelFood.value(sKey).toString();

    if (files=="")
    {
        QMessageBox::information(this, tr("Load File Settings"), tr("No settings file found, please update config."));
        configDialog = new ConfigDialog;
        configDialog->loadSettings();
        configDialog->exec();

        return 0;
    }

    QString sSearch;
    double dTotCost=0;


    int iSwitchFat; // For tracking the fat in the switch clause
    int fReturn;    // The answer to be returned at the end
    double dThisCal=0;
    double dThisFat=0;
    double dThisCost=0;

    // Initialise fReturn
    fReturn=0;

    if (files != "")
    {
        while (iFat>=0)
        {
            if (iFat>200)
            {
                iSwitchFat=200;
                iFat=iFat-200;
            }
            else
            {
                iSwitchFat = iFat;
                iFat=-1;
            }

            iSwitchFat = normaliseFat(iSwitchFat);
            sSearch="";
//            QTextStream(&sSearch) << iCals << "," << iSwitchFat << ",";

             QFile file(files);

             if (!file.open (QIODevice::ReadOnly))
             {
                 QMessageBox::information(this, tr("Unable to open file"),
                     file.errorString());
                 return 0;
             }
             else
             {
                 QTextStream stream ( &file );
                 bool found =false;
                 while( !stream.atEnd() && !found)
                 {
                      line = stream.readLine();

                      if (line.left(2)!="--") // skip comments
                      {
                          QStringList qslItems;
                          qslItems = line.split(",",QString::KeepEmptyParts );
                          QStringList::Iterator it = qslItems.begin();
                          int column=0;

                          while(it != qslItems.end())
                          {
                              switch (column)
                              {
                                  case 0:
                                  {
                                      QString sVal = *it;
                                      dThisCal = sVal.toDouble();
                                      break;
                                  }
                                  case 1:
                                  {
                                      QString sVal = *it;
                                      dThisFat = sVal.toDouble();
                                      break;
                                  }
                                  case 2:
                                  {
                                      QString sVal = *it;
                                      dThisCost = sVal.toDouble();
                                      break;
                                  }
                              }
                              it++;
                              column++;
                          }
                      }

                      if (iCals == dThisCal && iSwitchFat == dThisFat )
                      {
                          dTotCost += dThisCost;
                          found=true;
                      }
                 }
                 file.close(); // when your done.
             }
         }
        return dTotCost;
    }
    return dTotCost;
}

double MainWindow::getPoints()
{
    double   fPoints = 0;  // return value
    int   lCalsDiv;   // For rounding to nearest 20 cals
    int   iSwitchCals;// For tracing the cals in the switch clause

    // Initialise points
    fPoints=0;

    // Work out the the carlories. Round up to the nearest 20.
    lCalsDiv =  (int)(mdCals / 20);

    double calcMod = lCalsDiv * 20;

    if (mdCals > calcMod)
    {
        lCalsDiv++;
    }
    int lCals = lCalsDiv * 20;

    // Work out fat. Round up to nearest .5
    // Going to multiply fat by 10 and round to nearest 5...
//        lFatDiv = (int) ((fFat * 10) / 5);
    double fFat = mdSatFat;
    int iFat = (int) mdSatFat;
    if (iFat != mdSatFat)
    {
        double mdFat_Pt5 = iFat + .5;
        if (mdSatFat >mdFat_Pt5)
        {
            fFat = mdFat_Pt5 + .5;
        }
        else
        {
            fFat = mdFat_Pt5;
        }
    }
    fFat = fFat * 10;

    while (lCals>=0)
    {
        if (lCals>400)
        {
            iSwitchCals = 400;
            lCals=lCals-400;
        }
        else
        {
            iSwitchCals = (int) lCals;
            lCals=-1;
        }

        fPoints=fPoints+getPoints(iSwitchCals, fFat);
/*        switch (iSwitchCals)
        {
            case   0:   fPoints=fPoints+getPointsFor0(fFat); break;
            case  20:   fPoints=fPoints+getPointsFor20(fFat); break;
            case  40:   fPoints=fPoints+getPointsFor40(fFat); break;
            case  60:   fPoints=fPoints+getPointsFor60(fFat); break;
            case  80:   fPoints=fPoints+getPointsFor80(fFat); break;
            case 100:   fPoints=fPoints+getPointsFor100(fFat); break;
            case 120:   fPoints=fPoints+getPointsFor120(fFat); break;
            case 140:   fPoints=fPoints+getPointsFor140(fFat); break;
            case 160:   fPoints=fPoints+getPointsFor160(fFat); break;
            case 180:   fPoints=fPoints+getPointsFor180(fFat); break;
            case 200:   fPoints=fPoints+getPointsFor200(fFat); break;
            case 220:   fPoints=fPoints+getPointsFor220(fFat); break;
            case 240:   fPoints=fPoints+getPointsFor240(fFat); break;
            case 260:   fPoints=fPoints+getPointsFor260(fFat); break;
            case 280:   fPoints=fPoints+getPointsFor280(fFat); break;
            case 300:   fPoints=fPoints+getPointsFor300(fFat); break;
            case 320:   fPoints=fPoints+getPointsFor320(fFat); break;
            case 340:   fPoints=fPoints+getPointsFor340(fFat); break;
            case 360:   fPoints=fPoints+getPointsFor360(fFat); break;
            case 380:   fPoints=fPoints+getPointsFor380(fFat); break;
            case 400:   fPoints=fPoints+getPointsFor400(fFat); break;
            default: fPoints=fPoints+getPointsFor0(fFat); break;
        } */

    }
    //switch this.FCalories

    return fPoints;
}


void MainWindow::on_pushButton_Go_clicked()
{
    QString sss = ui->lineEdit->text();
    if (sss.length() == 0 )
    {
        ui->label_Answer->setText("Please enter a valid number");
        return;
    }

    if (ui->label_Main->text() == "Calories:")
    {

        ui->pushButton_Go->setText("Calculate");
        ui->label_Main->setText("Saturated Fat:");
        mdCals = ui->lineEdit->text().toDouble();
        ui->lineEdit->setText("");
    }
    else
    {
        mdSatFat = ui->lineEdit->text().toDouble();
        if (ui->pushButton_Go->text() == "Calculate")
        {
            double ans = getPoints();
            QString strAns = QString::number(ans);
            ui->label_Answer->setText(strAns);
        }
        ui->pushButton_Go->setVisible(false);
        ui->btnStore->setVisible(true);
    }

//    QString resultString = QString::number(convertCals * 3.4528,'f',2);
//    ui->label_Answer->setText(resultString);
}


void MainWindow::on_btnFoodLookup_clicked()
{
    // Display lookup
    foodDialog = new FoodDialog;
    foodDialog->exec();

}

void MainWindow::on_pushButton_clicked()
{
    trackeySummary= new TrackeySummary;
    trackeySummary->UpdateSummary();
    trackeySummary->exec();

}

void MainWindow::on_pushButton_10_clicked()
{
//    QDate dDate;
//    dDate.currentDate();
//    trackerDialog = new TrackerDialog;
//    trackerDialog->setDate(dDate.currentDate());
//    trackerDialog->exec();
    trackeySummary= new TrackeySummary;
    trackeySummary->UpdateSummary();
    trackeySummary->exec();
}

void MainWindow::on_toolButton_clicked()
{
    // Display lookup
    foodDialog = new FoodDialog;
    foodDialog->exec();

}

void MainWindow::on_toolButton_2_clicked()
{

}

void MainWindow::on_toolButton_3_clicked()
{
    //    QDate dDate;
    //    dDate.currentDate();
    //    trackerDialog = new TrackerDialog;
    //    trackerDialog->setDate(dDate.currentDate());
    //    trackerDialog->exec();
        trackeySummary= new TrackeySummary;
        trackeySummary->UpdateSummary();
        trackeySummary->exec();

}

void MainWindow::on_btnStore_clicked()
{
    storeFoodDialog = new StoreFood;
    storeFoodDialog->setMode("New");
    storeFoodDialog->setPoints(ui->label_Answer->text() );
    storeFoodDialog->exec();
    ui->pushButton_Go->setVisible(true);
    ui->btnStore->setVisible(false);
    on_pushButton_Clear_clicked();

}

void MainWindow::on_btnConfig_clicked()
{
    configDialog = new ConfigDialog;
    configDialog->loadSettings();
    configDialog->exec();

}

void MainWindow::on_btnWeight_clicked()
{
    weightTracker = new WeightTrackDialog;
    weightTracker->exec();
}

