/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/* $Id$ */
/*!
 * \file GamePlace.h
 * \brief Header of GamePlace
 * \todo add comment here
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */


#ifndef _GamePlace_H_8BC88838_2CD9_4436_9BA2_0DEC29CF3C88_INCLUDED_
#define _GamePlace_H_8BC88838_2CD9_4436_9BA2_0DEC29CF3C88_INCLUDED_
#include <QObject>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <QVector>

#include "Number.h"

 /*!
   * GamePlace is a QWidget. It should display the game place.
   * Method setPlace() set the game place.
   * Method changePlace() set the game play too, but
   * it should be shifting of some number from one field
   * to another.
   *
   */
class GamePlace : public QGraphicsView
{
    Q_OBJECT
  private:
    static int numberWidth;
    static int numberHeight;
    static int distanceBetweenNumbers;
    QVector<Number*> numbers;
    QGraphicsScene scene;

  public:
    GamePlace(QWidget *parent = 0);
    ~GamePlace();
    void drawPlace(int* array = 0);
    void shiftNumber(int number, int oldField, int newField);

    static int getNumberWidth();
    static int getNumberHeight();
    static int getDistanceBetweenNumbers();
    static void setNumberWidth(int w);
    static void setNumberHeight(int h);
    static void setDistanceBetweenNumbers(int dist);

  private:
        //GamePlace(const GamePlace& obj);
        //GamePlace& operator=(const GamePlace& obj);

}; // class GamePlace


#endif //_GamePlace_H_8BC88838_2CD9_4436_9BA2_0DEC29CF3C88_INCLUDED_

/* ===[ End of file $HeadURL$ ]=== */
