/*
 * Copyright 2010  Open Source & Linux Lab (OSLL)  maemo@osll.spb.ru
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * The advertising clause requiring mention in adverts must never be included.
 */

/* $Id$ */
/*!
 * \file Game.h
 * \brief Header of Game
 * \todo add comment here
 *
 * File description
 *
 * PROJ: 15shki
 * ---------------------------------------------------------------- */


#ifndef _Game_H_F928E33C_43F9_49D2_8DDD_95F136788CBC_INCLUDED_
#define _Game_H_F928E33C_43F9_49D2_8DDD_95F136788CBC_INCLUDED_

#include <QWidget>

#ifdef SYMBIAN_OS
#include <qaccelerometer.h>
#else
#include <QAccelerometer>
#endif

#ifndef SYMBIAN_OS
#include <QSystemInfo>
#endif

// QtMobility namespace
QTM_USE_NAMESPACE

#include <QObject>
#include "Model.h"
#include "GamePlace.h"
#include <QTimer>
#include <QDateTime>
#include <Phonon>
#include <QSound>

    /*!
     * Game is a composition of Model, QAccelerometer and GamePlace
     * QAccelerometer emits signal, slot onAccelerometerChanged()
     * analizes it and can call method of Model to "shake" it.
     *
     * If Model was changed by shaking it emits signal and slot
     * onModelChanged analize it and pass new disposition of
     * numbers as array to GamePlace method changePlace().
     *
     */
class Game : public QWidget
{
    Q_OBJECT

  private:
    Model model;
    QAccelerometer accelerometer;
    GamePlace gamePlace;
    int gameStarted;
    int movements;
    QTimer timer;
    int duration;
    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    QSound sound;
    
#ifndef SYMBIAN_OS
    QSystemScreenSaver systemScreenSaver;
#endif

  public:
    Game(QWidget *parent = 0);
    ~Game();
    void newGame();

    void setScreen(int width, int height);


  public slots:
    void onAccelerometerChanged();
    void accLeftImitator ();
    void accRightImitator ();
    void accUpImitator ();
    void accDownImitator ();
    void onModelShifted(int number, int oldField, int newField);
    void onModelFinished();
    void onTimerTimeout();

  signals:
    void finished();
    void movementsChanged(int movements);
    void durationChanged(int duration);


  private:
      int solvableArray(int *array);
        //Game(const Game& obj);
        //Game& operator=(const Game& obj);

}; // class Game

#endif //_Game_H_F928E33C_43F9_49D2_8DDD_95F136788CBC_INCLUDED_

/* ===[ End of file $HeadURL$ ]=== */
