
import time, datetime
import uuid
import format
from lib.store import Store as S
from app import config
from lib.util import locality, hasher, tz

class Store(S, ):
    _descriptions = {'account': {'id': int, 'token': unicode, 'last_sync': int, 'pro': bool, 'email': unicode, 'currency_default': unicode, 'language': unicode, 'timezone': int, 'format_date': unicode, 'format_number': unicode, 'token_secret': unicode}, 'expense': {'uuid': unicode, 'rel_account_id': int, 'amount': long, 'currency': unicode, 'description': unicode, 'date': unicode, 'sync': bool, 'date_modified': int, 'deleted': bool}, 'expense_to_tag': {'id': int, 'rel_expense_id': unicode, 'rel_tag_id': unicode}, 'tag': {'uuid': unicode, 'rel_account_id': int, 'name': unicode, 'count': int, 'sync': bool, 'date_modified': int, 'deleted': bool}, 'pref_var': {'name': unicode, 'value': unicode}}
    _preferences = {'account_id': (int, 0), 'sync_when': (int, 0), 'welcome_shown': (int, 0), 'initial_sync': (int, 1)}
    _account = None
    def _init_(self):
        
        self._con.create_function('utf_lower', 1, self.utfLower)
        self._con.create_collation('local', locality.getStrCol())
        self._account = None
        self._initPrefs()
        self.getAccount().assure()
    def utcUnix(self):
        return int(time.time())
    def getPref(self, name):
        assert (name in self._preferences)
        (typ, default) = self._preferences[name]
        row = self.select('pref_var', 'name = ?', name).fetchone()
        return typ(row['value'])
    def setPref(self, name, value):
        assert (name in self._preferences)
        self.update('pref_var', 'name = ?', name, value=value)
        self.commit()
    def _newPref(self, name, value):
        self.insert('pref_var', name=name, value=value)
    def _initPrefs(self):
        prefs = self.select('pref_var').fetchall()
        prefs = hasher(lambda row: row['name'], prefs)
        for (name, data) in self._preferences.items():
            if (name not in prefs):
                self._newPref(name, data[1])
                changed = True
    def getAccount(self):
        if not(self._account):
            self._account = Account(self._loadAccount(), self)
        return self._account
    def updateAccount(self, **kwargs):
        id = self.getAccount().getId()
        self.update('account', 'id = ?', id, **kwargs)
        self.commit()
        self._account = None
    def _loadAccount(self):
        
        id = self.getPref('account_id')
        account = self.getById('account', id)
        if not(account):
            res = self.select('account', order='id ASC', limit=1)
            (account, id) = (res.fetchone(), None)
            if not(account):
                data = {'pro': False, 'currency_default': 'EUR', 'language': locality.getLanguage(), 'timezone': locality.getTimezone(), 'format_date': '%d. %B %Y', 'last_sync': 0}
                data['format_number'] = u''.join(['%s', locality.getDecimalPoint(), '%s', '%s'])
                id = self.insert('account', **data)
                account = self.getById('account', id)
            if account:
                self.setPref('account_id', account['id'])
        return account
    def thingsChanged(self):
        c = 0
        last = self.getAccount().get('last_sync')
        sql = 'SELECT COUNT(uuid) FROM tag WHERE date_modified > ? AND sync = ? AND rel_account_id = ?'
        try:
            result = self.execute(sql, last, False, self.getAccount().get('id'))
            row = result.fetchone()
            c += row[0]
            del result
            del row
        except:
            c = 0
        if (c > 0):
            return True
        sql = 'SELECT COUNT(uuid) FROM expense WHERE date_modified > ? AND sync = ? AND rel_account_id = ?'
        try:
            result = self.execute(sql, last, False, self.getAccount().get('id'))
            row = result.fetchone()
            c += row[0]
            del result
            del row
        except:
            c = 0
        if (c > 0):
            return True
        return False
    def insertTag(self, **kwargs):
        if ('uuid' not in kwargs):
            kwargs['uuid'] = str(uuid.uuid4())
        if ('count' not in kwargs):
            kwargs['count'] = 0
        if ('rel_account_id' not in kwargs):
            kwargs['rel_account_id'] = self.getAccount().getId()
        if ('deleted' not in kwargs):
            kwargs['deleted'] = False
        if self.insert('tag', **kwargs):
            return kwargs['uuid']
        return False
    def updateTag(self, uuid, **kwargs):
        return self.update('tag', 'uuid = ?', uuid, **kwargs)
    def renameTag(self, uuid, name):
        self.updateTag(uuid, name=name, sync=False, date_modified=self.utcUnix())
    def incrementTags(self, uuids):
        (where, args) = self._sqlIn('uuid', uuids)
        args = ([False, self.utcUnix()] + args)
        result = self.execute(('UPDATE tag SET count = count + 1, sync = ?, date_modified = ? WHERE %s' % where), *args)
        del result
    def decrementTags(self, uuids):
        (where, args) = self._sqlIn('uuid', uuids)
        args = ([False, self.utcUnix()] + args)
        result = self.execute(('UPDATE tag SET count = count - 1, sync = ?, date_modified = ? WHERE %s' % where), *args)
        del result
    def clearTags(self):
        
        self.execute('UPDATE tag SET deleted = ? WHERE count < 1', True)
        self.execute('UPDATE tag SET deleted = ? WHERE count > 0', False)
    def selectTagsByExpense(self, rel_expense_id):
        return self.execute('SELECT * FROM tag\n                            JOIN expense_to_tag ON tag.uuid = expense_to_tag.rel_tag_id\n                            WHERE expense_to_tag.rel_expense_id = ?', rel_expense_id)
    def selectTagsForEdit(self):
        return self.select('tag', 'deleted <> ? AND count > ? AND rel_account_id = ?', True, 0, self.getAccount().getId(), order='name COLLATE local ASC ')
    def selectTagsByNames(self, names):
        (where, args) = self._sqlIn('utf_lower(name)', map(self.utfLower, names))
        where = ('%s AND deleted <> ? AND rel_account_id = ?' % where)
        args = (args + [True, self.getAccount().getId()])
        return self.select('tag', where, *args)
    def selectTopTags(self, limit=100):
        return self.select('tag', 'deleted <> ? AND count > ? AND rel_account_id = ?', 1, 0, self.getAccount().getId(), order='count DESC, name COLLATE local ASC', limit=limit)
    def selectTagsForSync(self, initSync=False):
        if initSync:
            return self.select('tag', 'rel_account_id = ?', self.getAccount().getId())
        else:
            return self.select('tag', 'sync = ? AND rel_account_id = ?', False, self.getAccount().getId())
    def getTopTags(self, limit=100):
        result = self.selectTopTags(limit)
        names = self.getValues(result, 'name')
        del result
        return names
    def countTags(self):
        result = self.execute('SELECT COUNT(uuid) FROM tag WHERE deleted <> ? AND rel_account_id = ?', True, self.getAccount().getId())
        row = result.fetchone()
        if row:
            return row[0]
        return 0
    def repair(self):
        sql = 'DELETE FROM expense_to_tag WHERE rel_expense_id NOT IN (SELECT uuid FROM expense)'
        self.execute(sql)
        sql = 'SELECT COUNT(expense_to_tag.rel_expense_id) FROM expense_to_tag\n        JOIN expense ON expense.uuid = expense_to_tag.rel_expense_id\n        WHERE expense.deleted <> ? AND expense_to_tag.rel_tag_id = ?'
        for tag in self.select('tag'):
            result = self.execute(sql, True, tag['uuid'])
            row = result.fetchone()
            if row:
                count = int(row[0])
                deleted = (count < 1)
                if ((tag['count'] != count) or (bool(tag['deleted']) != deleted)):
                    self.updateTag(tag['uuid'], count=count, deleted=deleted)
    def insertExpenseToTag(self, expense_id, tag_id):
        if (type(tag_id) in [list, tuple]):
            for tag in tag_id:
                self.insertExpenseToTag(expense_id, tag)
            return True
        else:
            return self.insert('expense_to_tag', rel_expense_id=expense_id, rel_tag_id=tag_id)
    def removeExpenseToTag(self, expense_id, tag_id):
        if not((type(tag_id) in [list, tuple])):
            tag_id = tuple(tag_id)
        (where, args) = self._sqlIn('rel_tag_id', tag_id)
        args = ([expense_id] + args)
        self.execute(('DELETE FROM expense_to_tag WHERE rel_expense_id = ? AND %s' % where), *args)
        pass
    def removeExpenseToTagByExpense(self, expense_id):
        return self.execute('DELETE FROM expense_to_tag WHERE rel_expense_id = ?', expense_id)
    def getExpense(self, uuid):
        sql = 'SELECT expense.amount, expense.date, expense.description, tag.name FROM expense\n        JOIN expense_to_tag ON expense_to_tag.rel_expense_id = expense.uuid\n        JOIN tag ON expense_to_tag.rel_tag_id = tag.uuid\n        WHERE expense.uuid = ?\n        '
        result = self.execute(sql, uuid)
        row1 = result.fetchone()
        if row1:
            data = {'amount': row1[0], 'date': format.parseDate(row1[1]), 'description': row1[2], 'tags': [row1[3]]}
            for row in result:
                data['tags'].append(row[3])
            del result
            del row1
            return data
        return None
    def selectExpensesForDisplay(self, timespan=None, limit=None, tags=False):
        tstring = ''
        args = [True, self.getAccount().getId()]
        if timespan:
            (start, end) = timespan
            tstring = ' AND date >= ? AND date <= ?'
            args.append(start.isoformat())
            args.append(end.isoformat())
        sql = ('SELECT expense.uuid, expense.amount, expense.date, tag.name FROM expense\n        JOIN expense_to_tag ON expense_to_tag.rel_expense_id = expense.uuid\n        JOIN tag ON expense_to_tag.rel_tag_id = tag.uuid\n        WHERE expense.deleted <> ? AND expense.rel_account_id = ?%s\n        ORDER BY%s expense.date DESC, expense.amount DESC' % (tstring, (' tag.name COLLATE local ASC,' if tags else '')))
        result = self.execute(sql, *args)
        orig_limit = limit
        lst = []
        (data, last, tags, i) = (None, None, None, 0)
        for row in result:
            if (last != row[0]):
                if (last != None):
                    data.append(tags)
                    lst.append(data)
                    if limit:
                        i += 1
                        if (limit == i):
                            if (limit <= (orig_limit * 3)):
                                limit += 1
                            (yield lst)
                            lst = []
                            i = 0
                last = row[0]
                data = [row[0], row[1], format.parseDate(row[2])]
                tags = [row[3]]
            else:
                tags.append(row[3])
        if (last != None):
            data.append(tags)
            lst.append(data)
        del result
        (yield lst)
    def getLastExpenseDate(self):
        sql = 'SELECT expense.date FROM expense WHERE deleted <> ? ORDER BY expense.date DESC LIMIT 1'
        result = self.execute(sql, True)
        row = result.fetchone()
        if row:
            return format.parseDate(row[0])
        return None
    def countExpensesForDisplay(self, timespan=None):
        tstring = ''
        args = [True, self.getAccount().getId()]
        if timespan:
            (start, end) = timespan
            tstring = ' AND date >= ? AND date <= ?'
            args.append(start.isoformat())
            args.append(end.isoformat())
        sql = ('SELECT COUNT(expense.uuid) FROM expense\n        WHERE expense.deleted <> ? AND rel_account_id = ?%s' % tstring)
        result = self.execute(sql, *args)
        try:
            row = result.fetchone()
            return row[0]
        except:
            return 0
    def selectTagsForDisplay(self, timespan=None):
        tstring = ''
        args = [True, self.getAccount().getId()]
        if timespan:
            (start, end) = timespan
            tstring = ' AND date >= ? AND date < ?'
            args.append(start.isoformat())
            args.append(end.isoformat())
        sql = ('SELECT DISTINCT(tag.name) FROM expense\n        JOIN expense_to_tag ON expense_to_tag.rel_expense_id = expense.uuid\n        JOIN tag ON expense_to_tag.rel_tag_id = tag.uuid\n        WHERE expense.deleted <> ? AND rel_account_id = ?%s\n        ORDER BY tag.count DESC, tag.name COLLATE local ASC' % tstring)
        result = self.execute(sql, *args)
        return result
    def getAmountsForComplete(self, limit=100):
        
        result = self.execute('SELECT DISTINCT(amount), COUNT(amount) AS count FROM expense WHERE deleted <> 1 GROUP BY amount ORDER BY count DESC')
        amounts = []
        for row in result:
            amounts.append(format.formatAmount(row[0], self.getAccount().getBareNumberFormat()).rstrip())
        del result
        return amounts
    def selectExpensesForSync(self, initSync=False):
        if initSync:
            return self.select('expense', 'rel_account_id = ?', self.getAccount().getId())
        else:
            return self.select('expense', 'sync = ? AND rel_account_id = ?', False, self.getAccount().getId())
    def isEmpty(self):
        
        res = self.select('expense', 'deleted <> ? AND rel_account_id = ?', True, self.getAccount().getId(), limit=1)
        if (res.fetchone() == None):
            return True
        return False
    def updateExpense(self, uuid, **kwargs):
        return self.updateByUuid('expense', uuid, **kwargs)
    def insertExpense(self, **kwargs):
        if ('uuid' not in kwargs):
            kwargs['uuid'] = str(uuid.uuid4())
        if ('rel_account_id' not in kwargs):
            kwargs['rel_account_id'] = self.getAccount().getId()
        if ('deleted' not in kwargs):
            kwargs['deleted'] = False
        if self.insert('expense', **kwargs):
            return kwargs['uuid']
        return False
    def userInsertExpense(self, amount, tags, description, date=None):
        description = format.parseDescription(description)
        if not(date):
            date = datetime.datetime.now(tz.local).date()
        uuid = self.insertExpense(amount=amount, description=description, date=date.isoformat(), date_modified=self.utcUnix(), currency=self.getAccount().getCurrency(), sync=False)
        self._updateExpenseToTags(uuid, tags, False)
        return uuid
    def _updateExpenseToTags(self, expense_id, tagList, checkLinked=True):
        linked = (self.selectTagsByExpense(expense_id).fetchall() if checkLinked else [])
        tags = self.selectTagsByNames(tagList).fetchall()
        tagNames = map(self.utfLower, self.getValues(tags, 'name'))
        created = False
        for name in tagList:
            if (self.utfLower(name) not in tagNames):
                self.insertTag(name=name, count=0)
                created = True
        if created:
            tags = self.selectTagsByNames(tagList).fetchall()
            tagNames = self.getValues(tags, 'name')
        linkedNames = self.getValues(linked, 'name')
        (toUnlink, toLink) = ([], [])
        for tag in linked:
            if (self.utfLower(tag['name']) not in map(self.utfLower, tagNames)):
                toUnlink.append(tag['uuid'])
        for tag in tags:
            if (self.utfLower(tag['name']) not in map(self.utfLower, linkedNames)):
                toLink.append(tag['uuid'])
        if (len(toLink) > 0):
            self.insertExpenseToTag(expense_id, toLink)
            self.incrementTags(toLink)
        if (len(toUnlink) > 0):
            self.removeExpenseToTag(expense_id, toUnlink)
            self.decrementTags(toUnlink)
        self.clearTags()
        return True
    def userUpdateExpense(self, uuid, amount, tags, description, date=None):
        description = format.parseDescription(description)
        if not(date):
            date = datetime.datetime.now().date()
        self.updateExpense(uuid, amount=amount, description=description, date=date.isoformat(), date_modified=self.utcUnix(), currency=self.getAccount().getCurrency(), sync=False)
        self._updateExpenseToTags(uuid, tags, True)
    def userDeleteExpense(self, uuid):
        tags = self.selectTagsByExpense(uuid)
        self.decrementTags(self.getValues(tags, 'uuid'))
        self.updateExpense(uuid, deleted=True, date_modified=self.utcUnix(), sync=False)
        return True

class Account(object, ):
    def __init__(self, row, store):
        self._row = row
        self._store = store
        self._numberFormat = None
        self._bareNumberFormat = None
    def get(self, name):
        return self._row[name]
    def getId(self):
        return self.get('id')
    def hasCustomCurrency(self):
        if (self.get('currency_default') in config.get('currencies_order')):
            return False
        return True
    def getCurrencySymbol(self):
        if self.hasCustomCurrency():
            return self.get('currency_default')
        return config.getSymbolForCurrency(self.get('currency_default'))
    def getCurrency(self):
        return self.get('currency_default')
    def getDateFormat(self):
        return str(self.get('format_date'))
    def getNumberFormat(self):
        if not(self._numberFormat):
            self._numberFormat = (self.get('format_number') % ('%s', '%s', (' %s' % self.getCurrencySymbol())))
        return self._numberFormat
    def getLastSync(self):
        ts = self.get('last_sync')
        if (ts > 0):
            return datetime.datetime.fromtimestamp(ts)
        return None
    def getBareNumberFormat(self):
        return (self.get('format_number') % ('%s', '%s', ''))
    def isLoggedIn(self):
        if ((self.get('token') != None) and (self.get('email') != None) and (len(self.get('token')) > 0) and (len(self.get('email')) > 0)):
            return True
        return False
    def logout(self):
        self._store.updateAccount(token='', token_secret='')
        self._store.setPref('initial_sync', 1)
    def isPro(self):
        return (self.get('pro') == True)
    def defaultDTFormat(self):
        return '%d. %B %Y'
    def assure(self):
        
        data = {'language': locality.getLanguage(), 'timezone': locality.getTimezone(), 'format_date': '%d. %B %Y', 'format_number': u''.join(['%s', locality.getDecimalPoint(), '%s', '%s'])}
        self._store.updateAccount(**data)
