
import gtk
from lib.mvc.ctrl import Ctrl
from app.view.main import *

class MainCtrl(Ctrl, ):
    def _init_(self):
        self._tsDialog = None
        self._tsDialogCustom = None
        self.getWidget().connect('key-press-event', self.on_key_press_event)
    def on_show(self, widget, data=None):
        shown = self.getApp().getStore().getPref('welcome_shown')
        if (shown == 0):
            self.getApp().pushView('welcome')
            self.getApp().getStore().setPref('welcome_shown', 1)
        if self.getApp().getAccount().isLoggedIn():
            self.getView().showSync()
    def on_appm_timeline_radio_clicked(self, widget, data=None):
        self.getCtrl('area').switch('timeline')
    def on_appm_tags_radio_clicked(self, widget, data=None):
        self.getCtrl('area').switch('tags')
    def on_appm_settings_button_clicked(self, widget, data=None):
        self.getApp().pushView('settings')
    def on_appm_synchronize_button_clicked(self, widget, data=None):
        self.getApp().getContext().synchronize()
    def on_key_press_event(self, widget, event, data=None):
        if (event.type == gtk.gdk.KEY_PRESS):
            key = gtk.gdk.keyval_name(event.keyval)
            if (key == 'Up'):
                self.getCtrl('area').getExpenseCtrl().upRow()
                return True
            else:
                if (key == 'Down'):
                    self.getCtrl('area').getExpenseCtrl().downRow()
                    return True
                else:
                    if (key == 'Right'):
                        self.getCtrl('area').getDetailCtrl().on_detail_button_edit_clicked()
                        return True
            unic = gtk.gdk.keyval_to_unicode(event.keyval)
            if (unic > 0):
                char = unichr(unic)
                self.getCtrl('area').scrollToSection(char)
        return True
    def on_appm_timespan_button_clicked(self, widget, data=None):
        if (self.getApp().getTimespan() in ('all', 'month')):
            self.show_timespan_dialog()
        else:
            self.show_timespan_custom_dialog()
    def show_timespan_dialog(self):
        self._tsDialogCustom = None
        self._tsDialog = TimespanDialog(self.getView())
        self._tsDialog.setOnTimespanSelected(self.on_timespan_selected)
        self._tsDialog.show_all()
    def show_timespan_custom_dialog(self):
        self._tsDialogCustom = TimespanDialog(self.getView(), True)
        self._tsDialogCustom.setOnTimespanSelected(self.on_timespan_selected)
        self._tsDialogCustom.setOnTimespanSelectedCustom(self.on_timespan_selected_custom)
        self._tsDialogCustom.show_all()
    def on_timespan_selected(self, i, custom=False):
        if (self._tsDialog or self._tsDialogCustom):
            if (i == 0):
                self.change_timespan('month')
                return True
            if (i == 1):
                self.change_timespan('all')
                return True
            if (i == 2):
                if not(self._tsDialogCustom):
                    self.show_timespan_custom_dialog()
                    return True
                else:
                    if custom:
                        return False
                return True
            return True
    def on_timespan_selected_custom(self, year, month):
        self.change_timespan(datetime.date(year, month, 1))
    def change_timespan(self, timespan):
        ts = self.getApp().getTimespan()
        if (ts != timespan):
            self.getApp().setTimespan(timespan)
            self.getCtrl('area').fill()
