
import logging
import gtk, hildon
import format
from lib.mvc.ctrl import Ctrl

class DetailCtrl(Ctrl, ):
    _expense = 'timeline'
    def _init_(self):
        self._filled = None
        self.getWidget('root_eb').connect('button-press-event', self.on_detail_root_button_press_event)
        self.getWidget('button_edit').connect('clicked', self.on_detail_button_edit_clicked)
        self.getWidget('button_delete').connect('clicked', self.on_detail_button_delete_clicked)
    def clear(self):
        self._filled = None
    def getExpenseView(self):
        return self.getView(self._expense)
    def fillExpense(self, uuid, force=True):
        if (not(force) and (uuid == self._filled)):
            pass
        else:
            expense = self.getApp().getStore().getExpense(uuid)
            if expense:
                self._filled = uuid
                self.getView().set_values({'amount': format.formatAmount(expense['amount'], self.getApp().getAccount().getNumberFormat()), 'tags': ', '.join(expense['tags']), 'description': expense['description'][:300], 'date': expense['date'].strftime('%d. %b %Y')})
    def on_show(self, widget, data=None):
        pass
    def on_detail_root_button_press_event(self, widget, data=None):
        self.getView().expand()
    def on_detail_button_edit_clicked(self, widget=None, data=None):
        if self._filled:
            self.getApp().pushView('add')
            self.getCtrl('add').before_edit(self._filled)
    def on_detail_button_delete_clicked(self, widget, data=None):
        if self._filled:
            note = hildon.Note('confirmation', self.getView('main').getWidget(), 'Do you really want to delete the expense?')
            ret = gtk.Dialog.run(note)
            if (ret == gtk.RESPONSE_OK):
                try:
                    if True:
                        f = self._filled
                        self.getApp().getStore().userDeleteExpense(f)
                        self.getApp().getStore().commit()
                        empty = False
                        if self.getCtrl('timeline').isFilled():
                            empty = self.getCtrl('timeline').removeRow(f)
                        if (not(empty) and self.getCtrl('tags').isFilled()):
                            self.getCtrl('tags').removeRow(f)
                except Exception, e:
                    logging.error('Failed to delete expense %s: %s', f, e)
            note.destroy()
