#include "routewindow.h"
#include "route.h"
#include "displayinfowidget.h"

#include <QDebug>
#include <QVBoxLayout>
#include <QScrollArea>

InfoWindow::InfoWindow() :
        QScrollArea(), mRoutes(QList<Route>())
{
    
    //    setAttribute(Qt::WA_DeleteOnClose);
    setWindowFlags(windowFlags() | Qt::Window);
    setWindowTitle(tr("Transports:"));
    mLayout = new QVBoxLayout();
    //    mLayout->setSizeConstraint(QLayout::SetMinimumSize);
    QWidget* widget = new QWidget(this); 
    widget->setLayout(mLayout);
    setWidget(widget);
    
}

InfoWindow::InfoWindow( Route route, QWidget *parent) :
        QScrollArea(parent ), mRoutes(QList<Route>()) //, mRoute(route)
{
    
    //    route.debug();
    
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setWindowFlags(Qt::Window);
    setWindowTitle(tr("Transports:"));
    mLayout = new QVBoxLayout();
    mLayout->setSizeConstraint(QLayout::SetMinimumSize);
    QWidget* mainWidget = new QWidget(this); 
    mainWidget->setLayout(mLayout);
    setWidget(mainWidget);
    
    Transport trans = route.next();
    
    displayInfoWidget* widget;
    
    
    //    widget = new displayInfoWidget();
    //    widget->setTitle(QString::fromLatin1("test"));
    //    layout->addWidget(widget);
    
    while(! trans.isEmpty() ) {
        
        trans.debug();
        qDebug() << "trans" << trans.line();
        widget = new displayInfoWidget();
        widget->displayTransport(trans);
        mLayout->addWidget(widget);
        trans = route.next();
    }
    //    layout->addWidget(new QWidget());
    mLayout->update();
}

InfoWindow::InfoWindow( const Route::List &routes, QWidget *parent) :
        QScrollArea(parent ), mRoutes(routes) {
    
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_DeleteOnClose);
    setWindowFlags(Qt::Window);
    setWindowTitle(tr("Routes:"));
    mLayout = new QVBoxLayout();
    mLayout->setSizeConstraint(QLayout::SetMinimumSize);
    QWidget* mainWidget = new QWidget(this); 
    mainWidget->setLayout(mLayout);
    setWidget(mainWidget);
    
    
    displayInfoWidget* widget;
    
    for (int i = 0; i < routes.count(); ++i) {
        
        const Route &route = routes.at(i);
        widget = new displayInfoWidget();
        widget->setRoute(route, i);
        mLayout->addWidget(widget);
        connect(widget, SIGNAL(clicked(int)), this, SLOT(elementClicked(int)));
        
    }
    
    mLayout->update();
    
    qDebug() << "routes" << mRoutes.count();
}


void InfoWindow::setRoute(Route route) {
    mRoute = route;
    
    Transport trans = route.next();
    
    displayInfoWidget* widget;
    
    
    //    widget = new displayInfoWidget();
    //    widget->setTitle(QString::fromLatin1("test"));
    //    layout->addWidget(widget);
    
    while(! trans.isEmpty() ) {
        
        trans.debug();
        qDebug() << "trans" << trans.line();
        widget = new displayInfoWidget();
        widget->displayTransport(trans);
        mLayout->addWidget(widget);
        mList.append(widget);
        trans = route.next();
    }
    
}

void InfoWindow::clearRoute() {
    
    foreach (QWidget* obj, mList) {
        mLayout->removeWidget(obj);
    }
}

bool InfoWindow::event( QEvent *event)
{
    //    qDebug() << "EVENT" << event->type();
    if (event->type() == QEvent::Close) {
        deleteLater();
        hide();
        qDebug("No window");
        return false;
    } else
        // standard event processing
        return QWidget::event(event);
}

void InfoWindow::elementClicked(int id) {
    
    qDebug() << id;
    qDebug() << mRoutes.count();
    qDebug() << mRoutes.at(id).time();
    InfoWindow *window = new InfoWindow( mRoutes.at(id),  this );
    window->show();
    
}
