#include "displayinfowidget.h"
#include <QPushButton>
#include <QGridLayout>
#include <QLabel>
#include <QDebug>
#include <QSize>
#include <QMouseEvent>
#include <QPainter>
#include <QPixmap>

#include "gps.h"

displayInfoWidget::displayInfoWidget(QWidget *parent) :
        QWidget(parent), state(0), mId(0)
{
    
    mGrid = new QGridLayout();
    mGrid->setSpacing(4);
    mGrid->setMargin(3);
    mIconLabel = new QLabel();
    mTitleLabel = new QLabel();
    mDescriptionLabel = new QLabel();
    mLineLabel = new QLabel();
    mMapButton = 0;
    mAlarmButton = 0;
    //    mIcon = 0;
    
    mGrid->setColumnStretch(1,2);
    
    mGrid->addWidget(mIconLabel, 0, 0, 1, 1);
    mGrid->addWidget(mTitleLabel, 0, 1, 1, 1);
    mGrid->addWidget(mLineLabel, 1, 0, 1, 1);
    mGrid->addWidget(mDescriptionLabel, 1, 1, 1, 1);
    
    setLayout(mGrid);
    
}

displayInfoWidget::~displayInfoWidget() {
    //    delete mIcon;
}

void displayInfoWidget::setRoute(const Route &ruta, int id) {
    
    mId = id;
    
    mTitleLabel->setText(ruta.startTime().toString("hh:mm")
                         + QString::fromLatin1(" -> ") +
                         ruta.endTime().toString("hh:mm"));
    //    QString sTime;
    //    qDebug() << ruta.time().minute();
    //    if (ruta.time() >= QTime(1,0))
    //        sTime = ruta.time().toString("h:mm");
    //    else
    //        sTime = ruta.time().toString("mm");
    
    mDescriptionLabel->setText( tr("Trans: ") + ruta.transportNames() +
                                QString::fromLatin1(" ") 
                                + tr(" Time: ") + ruta.time().toString("h:mm") 
                                + tr(" Walking: ") + 
                                QString::number(ruta.walking(), 'f', 1)
                                + tr(" km"));
    
    
    mIconLabel->setText(QString::number(ruta.realTransports()) );
    
}

void displayInfoWidget::displayTransport(const Transport &trans) {
    
    
    switch (trans.type()) {
        
    case Transport::Walk:
        mDescriptionLabel->setText( tr("Walk"));
        mTitleLabel->setText(QString::number(trans.distance() / 1000, 'f', 2)
                             + QString::fromLatin1(" km") );
        mIcon.load(":/icons/walk.png");
        mIconLabel->setPixmap( mIcon );
        break;
    case Transport::Bus:
        mLineLabel->setText( trans.line() );
        mIcon.load(":/icons/bus.png");
        mIconLabel->setPixmap( mIcon );
        break;
        
    case Transport::Metro:
        mDescriptionLabel->setText( tr("Metro") );
        mIcon.load(":/icons/metro.png");
        mIconLabel->setPixmap( mIcon );
        break;
        
    case Transport::Train:
        mLineLabel->setText( trans.line() );
        mIcon.load(":/icons/train.png");
        mIconLabel->setPixmap( mIcon );
        break;
        
    case Transport::Tram:
        mLineLabel->setText( trans.line() );
        mIcon.load(":/icons/tram.png");
        mIconLabel->setPixmap( mIcon );
        break;
        
    case Transport::Ferry:
        mIcon.load(":/icons/ferry.png");
        mIconLabel->setPixmap( mIcon );
        break;
        
    case Transport::Night:
        mIcon.load(":/icons/night.png");
        mIconLabel->setPixmap( mIcon );
        break;        
        
    }    
    
    if (trans.type() != Transport::Walk)
        mTitleLabel->setText(trans.startTime().toString("hh:mm") +
                             QString::fromLatin1(" -> ") +
                             trans.endTime().toString("hh:mm"));
    
    QPushButton *button = new QPushButton(tr("Stops"));
    mGrid->addWidget(button, 1,2,1,1);
    connect(button, SIGNAL(clicked()), this, SLOT(displayStops()));
    mStops = trans.stops();
}

void displayInfoWidget::displayStop(const Stop &stop) {
    
    mTitleLabel->setText(stop.name());
    mDescriptionLabel->setText(stop.arrivalTime().toString("hh:mm"));
#ifdef GPS
    QPushButton *button = new QPushButton(tr("Alarm"));
    mGrid->addWidget(button, 1,2,1,1);
    connect(button, SIGNAL(clicked()), this, SLOT(setAlarm()));
#endif
    mLocation = stop.coordinates();
    mTime = stop.arrivalTime();
}


void displayInfoWidget::clear() {
    
    QString blank;
    
    mTitleLabel->setText(blank);
    mDescriptionLabel->setText(blank);
    mIconLabel->setText(blank);
    mLineLabel->setText(blank);
    
    
}

void displayInfoWidget::mouseReleaseEvent ( QMouseEvent * event ) {
    
    Q_UNUSED(event);
    
    emit clicked(mId);
}

void displayInfoWidget::setTitle(const QString &title) {
    
    mTitleLabel->setText(title);
}

QSize displayInfoWidget::sizeHint() const {
    
    return QSize(300,20);
}

QSizePolicy displayInfoWidget::sizePolicy () const {
    
    return QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
}

void displayInfoWidget::paintEvent(QPaintEvent *) {
    
    QPainter painter(this);
    
    painter.drawRect(rect());
    
}

void displayInfoWidget::displayStops() {
    
    static_cast<QWidget*>(sender())->hide();
    if (!state) {
        displayInfoWidget* widget;
        int i = 2;
        foreach (const Stop& stop, mStops) {
            
            widget = new displayInfoWidget();
            widget->displayStop(stop);
            mGrid->addWidget(widget, i++ , 0, 1, 3);
            mWidgets.append(widget);
            
            
        }
        state = 1;
    } else {
        foreach(QWidget* widget, mWidgets) {
            //            mGrid->removeWidget(widget);
            widget->hide();
        }
        //        mWidgets.clear();
        state = 0;
    }
    update();
    
}


void displayInfoWidget::setAlarm() {
    
    Gps::instance()->setAlarm(mLocation, mTime);   
}
