#ifndef LOCATION_H
#define LOCATION_H

#include <QString>
#include <QList>
#include <QPair>

class QStandardItem;

typedef  QPair<int, int> FinnishCoordinates;    //Coordinates in the finnish system

#define makeFinnishCoordinates(fX, fY) FinnishCoordinates((fX), (fY));

/** Class to store the locations searched.

  */
class Location
{

public:
    /**
      List of locations
      */
    typedef QList<Location> List;

    explicit Location();

    explicit Location(const QString &name, const int number, const QString &city,
             const int code, const QString &address, const int type,
             const QString &category, const  int x, const int y,
             const float longitude, const float latitude);


    enum Category {
        street, stop, poi, unknown
            };

    QString name() const { return mName; }

    int number() const { return mNumber; }

    QString city() const { return mCity; }

    FinnishCoordinates finnishCoordinates() const;

    void debug() const;

    QStandardItem* model() const;
    
    QString toString() const;
   
    private:
        QString mName;
        int mNumber;
        QString mCity;
        int mCode;
        QString mAddress;
        int mType;
        Category mCategory;
        int mX;
        int mY;
        float mLongitude;
        float mLatitude;

};

#endif // LOCATION_H
